/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.testcontainers.service.connection.typesense;

import org.springframework.ai.autoconfigure.vectorstore.typesense.TypesenseConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.Container;

class TypesenseContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<Container<?>, TypesenseConnectionDetails> {
    TypesenseContainerConnectionDetailsFactory() {
        super("typesense/typesense", new String[0]);
    }

    protected TypesenseConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
        return new TypesenseContainerConnectionDetails(source);
    }

    private static final class TypesenseContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<Container<?>>
    implements TypesenseConnectionDetails {
        private TypesenseContainerConnectionDetails(ContainerConnectionSource<Container<?>> source) {
            super(source);
        }

        public String getHost() {
            return this.getContainer().getHost();
        }

        public String getProtocol() {
            return "http";
        }

        public int getPort() {
            return this.getContainer().getMappedPort(8108);
        }

        public String getApiKey() {
            return (String)this.getContainer().getEnvMap().get("TYPESENSE_API_KEY");
        }
    }
}

