/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.palm2;

import java.util.List;
import java.util.stream.Collectors;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.vertexai.palm2.VertexAiPaLm2ChatOptions;
import org.springframework.ai.vertexai.palm2.api.VertexAiPaLm2Api;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class VertexAiPaLm2ChatModel
implements ChatModel {
    private final VertexAiPaLm2Api vertexAiApi;
    private final VertexAiPaLm2ChatOptions defaultOptions;

    public VertexAiPaLm2ChatModel(VertexAiPaLm2Api vertexAiApi) {
        this(vertexAiApi, VertexAiPaLm2ChatOptions.builder().withTemperature(Float.valueOf(0.7f)).withCandidateCount(1).withTopK(20).build());
    }

    public VertexAiPaLm2ChatModel(VertexAiPaLm2Api vertexAiApi, VertexAiPaLm2ChatOptions defaultOptions) {
        Assert.notNull((Object)defaultOptions, (String)"Default options must not be null!");
        Assert.notNull((Object)vertexAiApi, (String)"VertexAiPaLm2Api must not be null!");
        this.vertexAiApi = vertexAiApi;
        this.defaultOptions = defaultOptions;
    }

    public ChatResponse call(Prompt prompt) {
        VertexAiPaLm2Api.GenerateMessageRequest request = this.createRequest(prompt);
        VertexAiPaLm2Api.GenerateMessageResponse response = this.vertexAiApi.generateMessage(request);
        List<Generation> generations = response.candidates().stream().map(vmsg -> new Generation(vmsg.content())).toList();
        return new ChatResponse(generations);
    }

    VertexAiPaLm2Api.GenerateMessageRequest createRequest(Prompt prompt) {
        String vertexContext = prompt.getInstructions().stream().filter(m -> m.getMessageType() == MessageType.SYSTEM).map(m -> m.getContent()).collect(Collectors.joining(System.lineSeparator()));
        List<VertexAiPaLm2Api.Message> vertexMessages = prompt.getInstructions().stream().filter(m -> m.getMessageType() == MessageType.USER || m.getMessageType() == MessageType.ASSISTANT).map(m -> new VertexAiPaLm2Api.Message(m.getMessageType().getValue(), m.getContent())).toList();
        Assert.isTrue((!CollectionUtils.isEmpty(vertexMessages) ? 1 : 0) != 0, (String)"No user or assistant messages found in the prompt!");
        VertexAiPaLm2Api.MessagePrompt vertexPrompt = new VertexAiPaLm2Api.MessagePrompt(vertexContext, vertexMessages);
        VertexAiPaLm2Api.GenerateMessageRequest request = new VertexAiPaLm2Api.GenerateMessageRequest(vertexPrompt);
        if (this.defaultOptions != null) {
            request = (VertexAiPaLm2Api.GenerateMessageRequest)ModelOptionsUtils.merge((Object)request, (Object)this.defaultOptions, VertexAiPaLm2Api.GenerateMessageRequest.class);
        }
        if (prompt.getOptions() != null) {
            VertexAiPaLm2ChatOptions updatedRuntimeOptions = (VertexAiPaLm2ChatOptions)ModelOptionsUtils.copyToTarget((Object)prompt.getOptions(), ChatOptions.class, VertexAiPaLm2ChatOptions.class);
            request = (VertexAiPaLm2Api.GenerateMessageRequest)ModelOptionsUtils.merge((Object)updatedRuntimeOptions, (Object)request, VertexAiPaLm2Api.GenerateMessageRequest.class);
        }
        return request;
    }

    public ChatOptions getDefaultOptions() {
        return VertexAiPaLm2ChatOptions.fromOptions(this.defaultOptions);
    }
}

