/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.palm2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.springframework.ai.chat.prompt.ChatOptions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VertexAiPaLm2ChatOptions
implements ChatOptions {
    @JsonProperty(value="temperature")
    private Float temperature;
    @JsonProperty(value="candidateCount")
    private Integer candidateCount;
    @JsonProperty(value="topP")
    private Float topP;
    @JsonProperty(value="topK")
    private Integer topK;

    public static Builder builder() {
        return new Builder();
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public Integer getCandidateCount() {
        return this.candidateCount;
    }

    public void setCandidateCount(Integer candidateCount) {
        this.candidateCount = candidateCount;
    }

    public Float getTopP() {
        return this.topP;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    @JsonIgnore
    public String getModel() {
        return null;
    }

    @JsonIgnore
    public Integer getMaxTokens() {
        return null;
    }

    @JsonIgnore
    public List<String> getStopSequences() {
        return null;
    }

    @JsonIgnore
    public Float getFrequencyPenalty() {
        return null;
    }

    @JsonIgnore
    public Float getPresencePenalty() {
        return null;
    }

    public VertexAiPaLm2ChatOptions copy() {
        return VertexAiPaLm2ChatOptions.fromOptions(this);
    }

    public static VertexAiPaLm2ChatOptions fromOptions(VertexAiPaLm2ChatOptions fromOptions) {
        return VertexAiPaLm2ChatOptions.builder().withTemperature(fromOptions.getTemperature()).withCandidateCount(fromOptions.getCandidateCount()).withTopP(fromOptions.getTopP()).withTopK(fromOptions.getTopK()).build();
    }

    public static class Builder {
        private VertexAiPaLm2ChatOptions options = new VertexAiPaLm2ChatOptions();

        public Builder withTemperature(Float temperature) {
            this.options.temperature = temperature;
            return this;
        }

        public Builder withCandidateCount(Integer candidateCount) {
            this.options.candidateCount = candidateCount;
            return this;
        }

        public Builder withTopP(Float topP) {
            this.options.topP = topP;
            return this;
        }

        public Builder withTopK(Integer topK) {
            this.options.topK = topK;
            return this;
        }

        public VertexAiPaLm2ChatOptions build() {
            return this.options;
        }
    }
}

