/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vertexai.palm2;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.ai.document.Document;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.vertexai.palm2.api.VertexAiPaLm2Api;

public class VertexAiPaLm2EmbeddingModel
extends AbstractEmbeddingModel {
    private final VertexAiPaLm2Api vertexAiApi;

    public VertexAiPaLm2EmbeddingModel(VertexAiPaLm2Api vertexAiApi) {
        this.vertexAiApi = vertexAiApi;
    }

    public float[] embed(Document document) {
        return this.embed(document.getContent());
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        List<VertexAiPaLm2Api.Embedding> vertexEmbeddings = this.vertexAiApi.batchEmbedText(request.getInstructions());
        AtomicInteger indexCounter = new AtomicInteger(0);
        List<Embedding> embeddings = vertexEmbeddings.stream().map(vm -> new Embedding(vm.value(), Integer.valueOf(indexCounter.getAndIncrement()))).toList();
        return new EmbeddingResponse(embeddings);
    }
}

