/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.remoting.client;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.remoting.support.DefaultRemoteInvocationFactory;
import org.springframework.remoting.support.RemoteAccessor;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationFactory;
import org.springframework.remoting.support.RemoteInvocationResult;

public class AmqpClientInterceptor
extends RemoteAccessor
implements MethodInterceptor {
    private AmqpTemplate amqpTemplate;
    private String routingKey = null;
    private RemoteInvocationFactory remoteInvocationFactory = new DefaultRemoteInvocationFactory();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        RemoteInvocation remoteInvocation = this.getRemoteInvocationFactory().createRemoteInvocation(invocation);
        Object rawResult = this.getRoutingKey() == null ? this.amqpTemplate.convertSendAndReceive(remoteInvocation) : this.amqpTemplate.convertSendAndReceive(this.routingKey, remoteInvocation);
        if (rawResult == null) {
            throw new RemoteProxyFailureException("No reply received - perhaps a timeout in the template?", null);
        }
        if (!(rawResult instanceof RemoteInvocationResult)) {
            throw new RemoteProxyFailureException("Expected a result of type " + RemoteInvocationResult.class.getCanonicalName() + " but found " + rawResult.getClass().getCanonicalName(), null);
        }
        RemoteInvocationResult result = (RemoteInvocationResult)rawResult;
        return result.recreate();
    }

    public AmqpTemplate getAmqpTemplate() {
        return this.amqpTemplate;
    }

    public void setAmqpTemplate(AmqpTemplate amqpTemplate) {
        this.amqpTemplate = amqpTemplate;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public RemoteInvocationFactory getRemoteInvocationFactory() {
        return this.remoteInvocationFactory;
    }

    public void setRemoteInvocationFactory(RemoteInvocationFactory remoteInvocationFactory) {
        this.remoteInvocationFactory = remoteInvocationFactory;
    }
}

