/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.utils.SerializationUtils;

public class Message
implements Serializable {
    private static final long serialVersionUID = -7177590352110605597L;
    private static final String ENCODING = Charset.defaultCharset().name();
    private final MessageProperties messageProperties;
    private final byte[] body;

    public Message(byte[] body, MessageProperties messageProperties) {
        this.body = body;
        this.messageProperties = messageProperties;
    }

    public byte[] getBody() {
        return this.body;
    }

    public MessageProperties getMessageProperties() {
        return this.messageProperties;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        buffer.append("Body:'" + this.getBodyContentAsString() + "'");
        if (this.messageProperties != null) {
            buffer.append(this.messageProperties.toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    private String getBodyContentAsString() {
        if (this.body == null) {
            return null;
        }
        try {
            String contentType;
            String string = contentType = this.messageProperties != null ? this.messageProperties.getContentType() : null;
            if ("application/x-java-serialized-object".equals(contentType)) {
                return SerializationUtils.deserialize(this.body).toString();
            }
            if ("text/plain".equals(contentType) || "application/json".equals(contentType) || "text/x-json".equals(contentType) || "application/xml".equals(contentType)) {
                return new String(this.body, ENCODING);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.body.toString() + "(byte[" + this.body.length + "])";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.body);
        result = 31 * result + (this.messageProperties == null ? 0 : this.messageProperties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        if (!Arrays.equals(this.body, other.body)) {
            return false;
        }
        return !(this.messageProperties == null ? other.messageProperties != null : !this.messageProperties.equals(other.messageProperties));
    }
}

