/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.Map;
import org.springframework.amqp.core.AbstractBuilder;
import org.springframework.amqp.core.AnonymousQueue;
import org.springframework.amqp.core.Queue;

public final class QueueBuilder
extends AbstractBuilder {
    private static final AnonymousQueue.NamingStrategy namingStrategy = new AnonymousQueue.Base64UrlNamingStrategy();
    private final String name;
    private boolean durable;
    private boolean exclusive;
    private boolean autoDelete;

    public static QueueBuilder durable() {
        return QueueBuilder.durable(namingStrategy.generateName());
    }

    public static QueueBuilder nonDurable() {
        return new QueueBuilder(namingStrategy.generateName());
    }

    public static QueueBuilder durable(String name) {
        return new QueueBuilder(name).setDurable();
    }

    public static QueueBuilder nonDurable(String name) {
        return new QueueBuilder(name);
    }

    private QueueBuilder(String name) {
        this.name = name;
    }

    private QueueBuilder setDurable() {
        this.durable = true;
        return this;
    }

    public QueueBuilder exclusive() {
        this.exclusive = true;
        return this;
    }

    public QueueBuilder autoDelete() {
        this.autoDelete = true;
        return this;
    }

    public QueueBuilder withArgument(String key, Object value) {
        this.getOrCreateArguments().put(key, value);
        return this;
    }

    public QueueBuilder withArguments(Map<String, Object> arguments) {
        this.getOrCreateArguments().putAll(arguments);
        return this;
    }

    public Queue build() {
        return new Queue(this.name, this.durable, this.exclusive, this.autoDelete, this.getArguments());
    }
}

