/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.Map;
import org.springframework.amqp.core.AbstractBuilder;
import org.springframework.amqp.core.Base64UrlNamingStrategy;
import org.springframework.amqp.core.NamingStrategy;
import org.springframework.amqp.core.Queue;

public final class QueueBuilder
extends AbstractBuilder {
    private static final NamingStrategy namingStrategy = Base64UrlNamingStrategy.DEFAULT;
    private final String name;
    private boolean durable;
    private boolean exclusive;
    private boolean autoDelete;

    public static QueueBuilder durable() {
        return QueueBuilder.durable(namingStrategy.generateName());
    }

    public static QueueBuilder nonDurable() {
        return new QueueBuilder(namingStrategy.generateName());
    }

    public static QueueBuilder durable(String name) {
        return new QueueBuilder(name).setDurable();
    }

    public static QueueBuilder nonDurable(String name) {
        return new QueueBuilder(name);
    }

    private QueueBuilder(String name) {
        this.name = name;
    }

    private QueueBuilder setDurable() {
        this.durable = true;
        return this;
    }

    public QueueBuilder exclusive() {
        this.exclusive = true;
        return this;
    }

    public QueueBuilder autoDelete() {
        this.autoDelete = true;
        return this;
    }

    public QueueBuilder withArgument(String key, Object value) {
        this.getOrCreateArguments().put(key, value);
        return this;
    }

    public QueueBuilder withArguments(Map<String, Object> arguments) {
        this.getOrCreateArguments().putAll(arguments);
        return this;
    }

    public QueueBuilder ttl(int ttl) {
        return this.withArgument("x-message-ttl", ttl);
    }

    public QueueBuilder expires(int expires) {
        return this.withArgument("x-expires", expires);
    }

    public QueueBuilder maxLength(int count) {
        return this.withArgument("x-max-length", count);
    }

    public QueueBuilder maxLengthBytes(int bytes) {
        return this.withArgument("x-max-length-bytes", bytes);
    }

    public QueueBuilder overflow(Overflow overflow) {
        return this.withArgument("x-overflow", overflow.getValue());
    }

    public QueueBuilder deadLetterExchange(String dlx) {
        return this.withArgument("x-dead-letter-exchange", dlx);
    }

    public QueueBuilder deadLetterRoutingKey(String dlrk) {
        return this.withArgument("x-dead-letter-routing-key", dlrk);
    }

    public QueueBuilder maxPriority(int maxPriority) {
        return this.withArgument("x-max-priority", maxPriority);
    }

    public QueueBuilder lazy() {
        return this.withArgument("x-queue-mode", "lazy");
    }

    public QueueBuilder masterLocator(MasterLocator locator) {
        return this.withArgument("x-queue-master-locator", locator.getValue());
    }

    public QueueBuilder singleActiveConsumer() {
        return this.withArgument("x-single-active-consumer", true);
    }

    public QueueBuilder quorum() {
        return this.withArgument("x-queue-type", "quorum");
    }

    public QueueBuilder deliveryLimit(int limit) {
        return this.withArgument("x-delivery-limit", limit);
    }

    public Queue build() {
        return new Queue(this.name, this.durable, this.exclusive, this.autoDelete, this.getArguments());
    }

    public static enum MasterLocator {
        minMasters("min-masters"),
        clientLocal("client-local"),
        random("random");

        private final String value;

        private MasterLocator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Overflow {
        dropHead("drop-head"),
        rejectPublish("reject-publish");

        private final String value;

        private Overflow(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

