/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.postprocessor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.springframework.amqp.support.postprocessor.AbstractDeflaterPostProcessor;

public class GZipPostProcessor
extends AbstractDeflaterPostProcessor {
    public GZipPostProcessor() {
    }

    public GZipPostProcessor(boolean autoDecompress) {
        super(autoDecompress);
    }

    @Override
    protected OutputStream getCompressorStream(OutputStream zipped) throws IOException {
        return new SettableLevelGZIPOutputStream(zipped, this.getLevel());
    }

    @Override
    protected String getEncoding() {
        return "gzip";
    }

    private static final class SettableLevelGZIPOutputStream
    extends GZIPOutputStream {
        SettableLevelGZIPOutputStream(OutputStream out, int level) throws IOException {
            super(out);
            this.def.setLevel(level);
        }
    }
}

