/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.Map;
import org.springframework.amqp.core.AbstractDeclarable;
import org.springframework.amqp.core.Queue;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Binding
extends AbstractDeclarable {
    @Nullable
    private final String destination;
    private final String exchange;
    @Nullable
    private final String routingKey;
    private final DestinationType destinationType;
    @Nullable
    private final Queue lazyQueue;

    public Binding(String destination, DestinationType destinationType, String exchange, String routingKey, @Nullable Map<String, Object> arguments) {
        this(null, destination, destinationType, exchange, routingKey, arguments);
    }

    public Binding(@Nullable Queue lazyQueue, @Nullable String destination, DestinationType destinationType, String exchange, @Nullable String routingKey, @Nullable Map<String, Object> arguments) {
        super(arguments);
        Assert.isTrue((lazyQueue == null || destinationType == DestinationType.QUEUE ? 1 : 0) != 0, (String)("'lazyQueue' must be null for destination type " + destinationType));
        Assert.isTrue((lazyQueue != null || destination != null ? 1 : 0) != 0, (String)"`destination` cannot be null");
        this.lazyQueue = lazyQueue;
        this.destination = destination;
        this.destinationType = destinationType;
        this.exchange = exchange;
        this.routingKey = routingKey;
    }

    public String getDestination() {
        if (this.lazyQueue != null) {
            return this.lazyQueue.getActualName();
        }
        return this.destination;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getRoutingKey() {
        if (this.routingKey == null && this.lazyQueue != null) {
            return this.lazyQueue.getActualName();
        }
        return this.routingKey;
    }

    public boolean isDestinationQueue() {
        return DestinationType.QUEUE.equals((Object)this.destinationType);
    }

    public String toString() {
        return "Binding [destination=" + this.destination + ", exchange=" + this.exchange + ", routingKey=" + this.routingKey + ", arguments=" + this.getArguments() + "]";
    }

    public static enum DestinationType {
        QUEUE,
        EXCHANGE;

    }
}

