/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.amqp.core.Declarable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Declarables {
    private final Collection<Declarable> declarables;

    public Declarables(Declarable ... declarables) {
        if (!ObjectUtils.isEmpty((Object[])declarables)) {
            this.declarables = new ArrayList<Declarable>(declarables.length);
            this.declarables.addAll(Arrays.asList(declarables));
        } else {
            this.declarables = new ArrayList<Declarable>();
        }
    }

    public Declarables(Collection<? extends Declarable> declarables) {
        Assert.notNull(declarables, (String)"declarables cannot be null");
        this.declarables = new ArrayList<Declarable>(declarables.size());
        this.declarables.addAll(declarables);
    }

    public Collection<Declarable> getDeclarables() {
        return this.declarables;
    }

    public <T extends Declarable> List<T> getDeclarablesByType(Class<? extends T> type) {
        return this.declarables.stream().filter(type::isInstance).map(type::cast).collect(Collectors.toList());
    }

    public String toString() {
        return "Declarables [declarables=" + String.valueOf(this.declarables) + "]";
    }
}

