/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.AllowedListDeserializingMessageConverter;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.ConfigurableObjectInputStream;
import org.springframework.core.serializer.DefaultDeserializer;
import org.springframework.core.serializer.DefaultSerializer;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.util.ClassUtils;

public class SerializerMessageConverter
extends AllowedListDeserializingMessageConverter
implements BeanClassLoaderAware {
    public static final String DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
    private String defaultCharset = DEFAULT_CHARSET;
    private Serializer<Object> serializer = new DefaultSerializer();
    private Deserializer<Object> deserializer = new DefaultDeserializer();
    private boolean ignoreContentType = false;
    private @Nullable ClassLoader defaultDeserializerClassLoader = ClassUtils.getDefaultClassLoader();
    private boolean usingDefaultDeserializer = true;

    public void setIgnoreContentType(boolean ignoreContentType) {
        this.ignoreContentType = ignoreContentType;
    }

    public void setDefaultCharset(@Nullable String defaultCharset) {
        this.defaultCharset = defaultCharset != null ? defaultCharset : DEFAULT_CHARSET;
    }

    public void setSerializer(Serializer<Object> serializer) {
        this.serializer = serializer;
    }

    public void setDeserializer(Deserializer<Object> deserializer) {
        this.deserializer = deserializer;
        this.usingDefaultDeserializer = false;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.defaultDeserializerClassLoader = classLoader;
    }

    @Override
    public Object fromMessage(Message message) throws MessageConversionException {
        Object content = null;
        MessageProperties properties = message.getMessageProperties();
        String contentType = properties.getContentType();
        if (contentType.startsWith("text") && !this.ignoreContentType) {
            content = this.asString(message, properties);
        } else if (contentType.equals("application/x-java-serialized-object") || this.ignoreContentType) {
            content = this.deserialize(message);
        }
        if (content == null) {
            content = message.getBody();
        }
        return content;
    }

    private Object deserialize(Message message) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(message.getBody());
            if (this.usingDefaultDeserializer) {
                return this.deserialize(inputStream);
            }
            return this.deserializer.deserialize((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new MessageConversionException("Could not convert message body", e);
        }
    }

    private Object asString(Message message, MessageProperties properties) {
        String encoding = properties.getContentEncoding();
        if (encoding == null) {
            encoding = this.defaultCharset;
        }
        try {
            return new String(message.getBody(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new MessageConversionException("failed to convert text-based Message content", e);
        }
    }

    private Object deserialize(ByteArrayInputStream inputStream) throws IOException {
        Object object;
        ConfigurableObjectInputStream objectInputStream = new ConfigurableObjectInputStream(inputStream, this.defaultDeserializerClassLoader){

            protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
                Class clazz = super.resolveClass(classDesc);
                SerializerMessageConverter.this.checkAllowedList(clazz);
                return clazz;
            }
        };
        try {
            object = objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException ex) {
                throw new IOException("Failed to deserialize object type", ex);
            }
        }
        objectInputStream.close();
        return object;
    }

    @Override
    protected Message createMessage(Object object, MessageProperties messageProperties) throws MessageConversionException {
        byte[] bytes;
        if (object instanceof String) {
            String string = (String)object;
            try {
                bytes = string.getBytes(this.defaultCharset);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessageConversionException("failed to convert Message content", e);
            }
            messageProperties.setContentType("text/plain");
            messageProperties.setContentEncoding(this.defaultCharset);
        } else if (object instanceof byte[]) {
            byte[] objectBytes;
            bytes = objectBytes = (byte[])object;
            messageProperties.setContentType("application/octet-stream");
        } else {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                this.serializer.serialize(object, (OutputStream)output);
            }
            catch (IOException e) {
                throw new MessageConversionException("Cannot convert object to bytes", e);
            }
            bytes = output.toByteArray();
            messageProperties.setContentType("application/x-java-serialized-object");
        }
        messageProperties.setContentLength(bytes.length);
        return new Message(bytes, messageProperties);
    }
}

