/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.test.mockito;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.springframework.lang.Nullable;

public class LatchCountDownAndCallRealMethodAnswer
implements Answer<Void> {
    private final CountDownLatch latch;
    private final Set<Exception> exceptions = Collections.synchronizedSet(new LinkedHashSet());

    public LatchCountDownAndCallRealMethodAnswer(int count) {
        this.latch = new CountDownLatch(count);
    }

    public Void answer(InvocationOnMock invocation) throws Throwable {
        try {
            invocation.callRealMethod();
        }
        catch (Exception e) {
            this.exceptions.add(e);
            throw e;
        }
        finally {
            this.latch.countDown();
        }
        return null;
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    @Nullable
    public Collection<Exception> getExceptions() {
        return Collections.unmodifiableCollection(this.exceptions);
    }
}

