/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class AdminParser
extends AbstractSingleBeanDefinitionParser {
    private static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    private static final String AUTO_STARTUP_ATTRIBUTE = "auto-startup";

    AdminParser() {
    }

    protected String getBeanClassName(Element element) {
        return "org.springframework.amqp.rabbit.core.RabbitAdmin";
    }

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String attributeValue;
        String connectionFactoryRef = element.getAttribute(CONNECTION_FACTORY_ATTRIBUTE);
        if (!StringUtils.hasText((String)connectionFactoryRef)) {
            parserContext.getReaderContext().error("A 'connection-factory' attribute must be set.", (Object)element);
        }
        if (StringUtils.hasText((String)connectionFactoryRef)) {
            builder.addConstructorArgReference(connectionFactoryRef);
        }
        if (StringUtils.hasText((String)(attributeValue = element.getAttribute(AUTO_STARTUP_ATTRIBUTE)))) {
            builder.addPropertyValue("autoStartup", (Object)attributeValue);
        }
    }
}

