/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.amqp.rabbit.config.NamespaceUtils;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TemplateParser
extends AbstractSingleBeanDefinitionParser {
    private static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    private static final String EXCHANGE_ATTRIBUTE = "exchange";
    private static final String QUEUE_ATTRIBUTE = "queue";
    private static final String ROUTING_KEY_ATTRIBUTE = "routing-key";
    private static final String REPLY_TIMEOUT_ATTRIBUTE = "reply-timeout";
    private static final String MESSAGE_CONVERTER_ATTRIBUTE = "message-converter";
    private static final String ENCODING_ATTRIBUTE = "encoding";
    private static final String CHANNEL_TRANSACTED_ATTRIBUTE = "channel-transacted";

    TemplateParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return RabbitTemplate.class;
    }

    protected boolean shouldGenerateId() {
        return false;
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String connectionFactoryRef = element.getAttribute(CONNECTION_FACTORY_ATTRIBUTE);
        if (!StringUtils.hasText((String)connectionFactoryRef)) {
            parserContext.getReaderContext().error("A 'connection-factory' attribute must be set.", (Object)element);
        }
        if (StringUtils.hasText((String)connectionFactoryRef)) {
            builder.addConstructorArgReference(connectionFactoryRef);
        }
        NamespaceUtils.setValueIfAttributeDefined(builder, element, CHANNEL_TRANSACTED_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, QUEUE_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, EXCHANGE_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, ROUTING_KEY_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, REPLY_TIMEOUT_ATTRIBUTE);
        NamespaceUtils.setValueIfAttributeDefined(builder, element, ENCODING_ATTRIBUTE);
        NamespaceUtils.setReferenceIfAttributeDefined(builder, element, MESSAGE_CONVERTER_ATTRIBUTE);
    }
}

