/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.retry;

import java.util.UUID;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.listener.ListenerExecutionFailedException;
import org.springframework.retry.policy.RetryContextCache;
import org.springframework.util.Assert;

public class MissingMessageIdAdvice
implements MethodInterceptor {
    private static final Log logger = LogFactory.getLog(MissingMessageIdAdvice.class);
    private final RetryContextCache retryContextCache;

    public MissingMessageIdAdvice(RetryContextCache retryContextCache) {
        Assert.notNull((Object)retryContextCache, (String)"RetryContextCache must not be null");
        this.retryContextCache = retryContextCache;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object object;
        block8: {
            String id = null;
            Message message = null;
            boolean redelivered = false;
            try {
                message = (Message)invocation.getArguments()[1];
                MessageProperties messageProperties = message.getMessageProperties();
                if (messageProperties.getMessageId() == null) {
                    id = UUID.randomUUID().toString();
                    messageProperties.setMessageId(id);
                }
                redelivered = messageProperties.isRedelivered();
                object = invocation.proceed();
                if (id == null) break block8;
            }
            catch (Throwable t) {
                try {
                    if (id != null && redelivered) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Canceling delivery of retried message that has no ID");
                        }
                        throw new ListenerExecutionFailedException("Cannot retry message without an ID", (Throwable)new AmqpRejectAndDontRequeueException(t), message);
                    }
                    throw t;
                }
                catch (Throwable throwable) {
                    if (id != null) {
                        this.retryContextCache.remove(id);
                    }
                    throw throwable;
                }
            }
            this.retryContextCache.remove((Object)id);
        }
        return object;
    }
}

