/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.support;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.LongString;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.amqp.AmqpUnsupportedEncodingException;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.util.CollectionUtils;

public class DefaultMessagePropertiesConverter
implements MessagePropertiesConverter {
    @Override
    public MessageProperties toMessageProperties(AMQP.BasicProperties source, Envelope envelope, String charset) {
        String replyTo;
        MessageProperties target = new MessageProperties();
        Map headers = source.getHeaders();
        if (!CollectionUtils.isEmpty((Map)headers)) {
            for (Map.Entry entry : headers.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof LongString) {
                    value = this.convertLongString((LongString)value, charset);
                }
                target.setHeader((String)entry.getKey(), value);
            }
        }
        target.setTimestamp(source.getTimestamp());
        target.setMessageId(source.getMessageId());
        target.setUserId(source.getUserId());
        target.setAppId(source.getAppId());
        target.setClusterId(source.getClusterId());
        target.setType(source.getType());
        Integer deliverMode = source.getDeliveryMode();
        if (deliverMode != null) {
            target.setDeliveryMode(MessageDeliveryMode.fromInt((int)deliverMode));
        }
        target.setExpiration(source.getExpiration());
        target.setPriority(source.getPriority());
        target.setContentType(source.getContentType());
        target.setContentEncoding(source.getContentEncoding());
        String correlationId = source.getCorrelationId();
        if (correlationId != null) {
            try {
                target.setCorrelationId(source.getCorrelationId().getBytes(charset));
            }
            catch (UnsupportedEncodingException ex) {
                throw new AmqpUnsupportedEncodingException((Throwable)ex);
            }
        }
        if ((replyTo = source.getReplyTo()) != null) {
            target.setReplyTo(replyTo);
        }
        if (envelope != null) {
            target.setReceivedExchange(envelope.getExchange());
            target.setReceivedRoutingKey(envelope.getRoutingKey());
            target.setRedelivered(Boolean.valueOf(envelope.isRedeliver()));
            target.setDeliveryTag(envelope.getDeliveryTag());
        }
        return target;
    }

    @Override
    public AMQP.BasicProperties fromMessageProperties(MessageProperties source, String charset) {
        String replyTo;
        AMQP.BasicProperties.Builder target = new AMQP.BasicProperties.Builder();
        target.headers(this.convertHeadersIfNecessary(source.getHeaders()));
        target.timestamp(source.getTimestamp());
        target.messageId(source.getMessageId());
        target.userId(source.getUserId());
        target.appId(source.getAppId());
        target.clusterId(source.getClusterId());
        target.type(source.getType());
        MessageDeliveryMode deliveryMode = source.getDeliveryMode();
        if (deliveryMode != null) {
            target.deliveryMode(Integer.valueOf(MessageDeliveryMode.toInt((MessageDeliveryMode)deliveryMode)));
        }
        target.expiration(source.getExpiration());
        target.priority(source.getPriority());
        target.contentType(source.getContentType());
        target.contentEncoding(source.getContentEncoding());
        byte[] correlationId = source.getCorrelationId();
        if (correlationId != null && correlationId.length > 0) {
            try {
                target.correlationId(new String(correlationId, charset));
            }
            catch (UnsupportedEncodingException ex) {
                throw new AmqpUnsupportedEncodingException((Throwable)ex);
            }
        }
        if ((replyTo = source.getReplyTo()) != null) {
            target.replyTo(replyTo);
        }
        return target.build();
    }

    private Map<String, Object> convertHeadersIfNecessary(Map<String, Object> headers) {
        if (CollectionUtils.isEmpty(headers)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> writableHeaders = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            writableHeaders.put(entry.getKey(), this.convertHeaderValueIfNecessary(entry.getValue()));
        }
        return writableHeaders;
    }

    private Object convertHeaderValueIfNecessary(Object value) {
        boolean valid;
        boolean bl = valid = value instanceof String || value instanceof byte[] || value instanceof Boolean || value instanceof LongString || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal || value instanceof Short || value instanceof Byte || value instanceof Date || value instanceof List || value instanceof Map;
        if (!valid && value != null) {
            value = value.toString();
        }
        return value;
    }

    private Object convertLongString(LongString longString, String charset) {
        try {
            if (longString.length() <= 1024L) {
                return new String(longString.getBytes(), charset);
            }
            return longString.getStream();
        }
        catch (Exception e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }
}

