/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ExceptionHandler;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.client.SocketConfigurator;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RabbitConnectionFactoryBean
extends AbstractFactoryBean<ConnectionFactory> {
    protected final ConnectionFactory connectionFactory = new ConnectionFactory();
    private boolean useSSL;
    private Resource sslPropertiesLocation;
    private volatile String sslAlgorithm = "SSLv3";
    private volatile boolean sslAlgorithmSet;

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    protected boolean isUseSSL() {
        return this.useSSL;
    }

    public void setSslAlgorithm(String sslAlgorithm) {
        this.sslAlgorithm = sslAlgorithm;
        this.sslAlgorithmSet = true;
    }

    protected String getSslAlgorithm() {
        return this.sslAlgorithm;
    }

    public void setSslPropertiesLocation(Resource sslPropertiesLocation) {
        this.sslPropertiesLocation = sslPropertiesLocation;
    }

    protected Resource getSslPropertiesLocation() {
        return this.sslPropertiesLocation;
    }

    public void setHost(String host) {
        this.connectionFactory.setHost(host);
    }

    public void setPort(int port) {
        this.connectionFactory.setPort(port);
    }

    public void setUsername(String username) {
        this.connectionFactory.setUsername(username);
    }

    public void setPassword(String password) {
        this.connectionFactory.setPassword(password);
    }

    public void setVirtualHost(String virtualHost) {
        this.connectionFactory.setVirtualHost(virtualHost);
    }

    public void setUri(URI uri) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        this.connectionFactory.setUri(uri);
    }

    public void setUri(String uriString) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        this.connectionFactory.setUri(uriString);
    }

    public void setRequestedChannelMax(int requestedChannelMax) {
        this.connectionFactory.setRequestedChannelMax(requestedChannelMax);
    }

    public void setRequestedFrameMax(int requestedFrameMax) {
        this.connectionFactory.setRequestedFrameMax(requestedFrameMax);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionFactory.setConnectionTimeout(connectionTimeout);
    }

    public void setRequestedHeartbeat(int requestedHeartbeat) {
        this.connectionFactory.setRequestedHeartbeat(requestedHeartbeat);
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this.connectionFactory.setClientProperties(clientProperties);
    }

    public void setSaslConfig(SaslConfig saslConfig) {
        this.connectionFactory.setSaslConfig(saslConfig);
    }

    public void setSocketFactory(SocketFactory factory) {
        this.connectionFactory.setSocketFactory(factory);
    }

    public void setSocketConfigurator(SocketConfigurator socketConfigurator) {
        this.connectionFactory.setSocketConfigurator(socketConfigurator);
    }

    public void setSharedExecutor(ExecutorService executor) {
        this.connectionFactory.setSharedExecutor(executor);
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.connectionFactory.setThreadFactory(threadFactory);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.connectionFactory.setExceptionHandler(exceptionHandler);
    }

    public Class<?> getObjectType() {
        return ConnectionFactory.class;
    }

    protected ConnectionFactory createInstance() throws Exception {
        if (this.useSSL) {
            this.setUpSSL();
        }
        return this.connectionFactory;
    }

    protected void setUpSSL() throws Exception {
        if (this.sslPropertiesLocation == null) {
            if (this.sslAlgorithmSet) {
                this.connectionFactory.useSslProtocol(this.sslAlgorithm);
            } else {
                this.connectionFactory.useSslProtocol();
            }
        } else {
            Properties sslProperties = new Properties();
            sslProperties.load(this.sslPropertiesLocation.getInputStream());
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            String keyStoreName = sslProperties.getProperty("keyStore");
            Assert.state((boolean)StringUtils.hasText((String)keyStoreName), (String)"keyStore property required");
            String trustStoreName = sslProperties.getProperty("trustStore");
            Assert.state((boolean)StringUtils.hasText((String)trustStoreName), (String)"trustStore property required");
            String keyStorePassword = sslProperties.getProperty("keyStore.passPhrase");
            Assert.state((boolean)StringUtils.hasText((String)keyStorePassword), (String)"keyStore.passPhrase property required");
            String trustStorePassword = sslProperties.getProperty("trustStore.passPhrase");
            Assert.state((boolean)StringUtils.hasText((String)trustStorePassword), (String)"trustStore.passPhrase property required");
            Resource keyStore = resolver.getResource(keyStoreName);
            Resource trustStore = resolver.getResource(trustStoreName);
            char[] keyPassphrase = keyStorePassword.toCharArray();
            char[] trustPassphrase = trustStorePassword.toCharArray();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(keyStore.getInputStream(), keyPassphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, keyPassphrase);
            KeyStore tks = KeyStore.getInstance("JKS");
            tks.load(trustStore.getInputStream(), trustPassphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(tks);
            SSLContext context = this.createSSLContext();
            context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            this.connectionFactory.useSslProtocol(context);
        }
    }

    protected SSLContext createSSLContext() throws NoSuchAlgorithmException {
        return SSLContext.getInstance(this.sslAlgorithm);
    }
}

