/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.rabbit.listener.FatalExceptionStrategy;
import org.springframework.amqp.rabbit.listener.exception.ListenerExecutionFailedException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.handler.annotation.support.MethodArgumentNotValidException;
import org.springframework.messaging.handler.annotation.support.MethodArgumentTypeMismatchException;
import org.springframework.util.ErrorHandler;

public class ConditionalRejectingErrorHandler
implements ErrorHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final FatalExceptionStrategy exceptionStrategy;

    public ConditionalRejectingErrorHandler() {
        this.exceptionStrategy = new DefaultExceptionStrategy();
    }

    public ConditionalRejectingErrorHandler(FatalExceptionStrategy exceptionStrategy) {
        this.exceptionStrategy = exceptionStrategy;
    }

    public void handleError(Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"Execution of Rabbit message listener failed.", t);
        }
        if (!this.causeChainContainsARADRE(t) && this.exceptionStrategy.isFatal(t)) {
            throw new AmqpRejectAndDontRequeueException("Error Handler converted exception to fatal", t);
        }
    }

    private boolean causeChainContainsARADRE(Throwable t) {
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof AmqpRejectAndDontRequeueException)) continue;
            return true;
        }
        return false;
    }

    public class DefaultExceptionStrategy
    implements FatalExceptionStrategy {
        @Override
        public boolean isFatal(Throwable t) {
            if (t instanceof ListenerExecutionFailedException && this.isCauseFatal(t.getCause())) {
                if (ConditionalRejectingErrorHandler.this.logger.isWarnEnabled()) {
                    ConditionalRejectingErrorHandler.this.logger.warn((Object)("Fatal message conversion error; message rejected; it will be dropped or routed to a dead letter exchange, if so configured: " + ((ListenerExecutionFailedException)((Object)t)).getFailedMessage()));
                }
                return true;
            }
            return false;
        }

        private boolean isCauseFatal(Throwable cause) {
            return cause instanceof org.springframework.amqp.support.converter.MessageConversionException || cause instanceof MessageConversionException || cause instanceof MethodArgumentNotValidException || cause instanceof MethodArgumentTypeMismatchException || cause instanceof NoSuchMethodException || cause instanceof ClassCastException || this.isUserCauseFatal(cause);
        }

        protected boolean isUserCauseFatal(Throwable cause) {
            return false;
        }
    }
}

