/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.RoutingConnectionFactory;
import org.springframework.util.Assert;

public abstract class AbstractRoutingConnectionFactory
implements ConnectionFactory,
RoutingConnectionFactory {
    private final Map<Object, ConnectionFactory> targetConnectionFactories = new ConcurrentHashMap<Object, ConnectionFactory>();
    private final List<ConnectionListener> connectionListeners = new ArrayList<ConnectionListener>();
    private ConnectionFactory defaultTargetConnectionFactory;
    private boolean lenientFallback = true;

    public void setTargetConnectionFactories(Map<Object, ConnectionFactory> targetConnectionFactories) {
        Assert.notNull(targetConnectionFactories, (String)"'targetConnectionFactories' must not be null.");
        Assert.noNullElements((Object[])targetConnectionFactories.values().toArray(), (String)"'targetConnectionFactories' cannot have null values.");
        this.targetConnectionFactories.putAll(targetConnectionFactories);
    }

    public void setDefaultTargetConnectionFactory(ConnectionFactory defaultTargetConnectionFactory) {
        this.defaultTargetConnectionFactory = defaultTargetConnectionFactory;
    }

    public void setLenientFallback(boolean lenientFallback) {
        this.lenientFallback = lenientFallback;
    }

    public boolean isLenientFallback() {
        return this.lenientFallback;
    }

    @Override
    public Connection createConnection() throws AmqpException {
        return this.determineTargetConnectionFactory().createConnection();
    }

    protected ConnectionFactory determineTargetConnectionFactory() {
        Object lookupKey = this.determineCurrentLookupKey();
        ConnectionFactory connectionFactory = null;
        if (lookupKey != null) {
            connectionFactory = this.targetConnectionFactories.get(lookupKey);
        }
        if (connectionFactory == null && (this.lenientFallback || lookupKey == null)) {
            connectionFactory = this.defaultTargetConnectionFactory;
        }
        if (connectionFactory == null) {
            throw new IllegalStateException("Cannot determine target ConnectionFactory for lookup key [" + lookupKey + "]");
        }
        return connectionFactory;
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        for (ConnectionFactory connectionFactory : this.targetConnectionFactories.values()) {
            connectionFactory.addConnectionListener(listener);
        }
        if (this.defaultTargetConnectionFactory != null) {
            this.defaultTargetConnectionFactory.addConnectionListener(listener);
        }
        this.connectionListeners.add(listener);
    }

    @Override
    public boolean removeConnectionListener(ConnectionListener listener) {
        boolean removed = false;
        for (ConnectionFactory connectionFactory : this.targetConnectionFactories.values()) {
            boolean listenerRemoved = connectionFactory.removeConnectionListener(listener);
            if (removed) continue;
            removed = listenerRemoved;
        }
        if (this.defaultTargetConnectionFactory != null) {
            boolean listenerRemoved = this.defaultTargetConnectionFactory.removeConnectionListener(listener);
            if (!removed) {
                removed = listenerRemoved;
            }
        }
        this.connectionListeners.remove(listener);
        return removed;
    }

    @Override
    public void clearConnectionListeners() {
        for (ConnectionFactory connectionFactory : this.targetConnectionFactories.values()) {
            connectionFactory.clearConnectionListeners();
        }
        if (this.defaultTargetConnectionFactory != null) {
            this.defaultTargetConnectionFactory.clearConnectionListeners();
        }
        this.connectionListeners.clear();
    }

    @Override
    public String getHost() {
        return this.determineTargetConnectionFactory().getHost();
    }

    @Override
    public int getPort() {
        return this.determineTargetConnectionFactory().getPort();
    }

    @Override
    public String getVirtualHost() {
        return this.determineTargetConnectionFactory().getVirtualHost();
    }

    @Override
    public String getUsername() {
        return this.determineTargetConnectionFactory().getUsername();
    }

    @Override
    public ConnectionFactory getTargetConnectionFactory(Object key) {
        return this.targetConnectionFactories.get(key);
    }

    protected void addTargetConnectionFactory(Object key, ConnectionFactory connectionFactory) {
        this.targetConnectionFactories.put(key, connectionFactory);
        for (ConnectionListener listener : this.connectionListeners) {
            connectionFactory.addConnectionListener(listener);
        }
    }

    protected ConnectionFactory removeTargetConnectionFactory(Object key) {
        return this.targetConnectionFactories.remove(key);
    }

    protected abstract Object determineCurrentLookupKey();
}

