/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.utility.Utility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpAuthenticationException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIOException;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.listener.ActiveObjectCounter;
import org.springframework.amqp.rabbit.listener.ConsumeOkEvent;
import org.springframework.amqp.rabbit.listener.QueuesNotAvailableException;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerStartupException;
import org.springframework.amqp.rabbit.support.ClosingRecoveryListener;
import org.springframework.amqp.rabbit.support.ConsumerCancelledException;
import org.springframework.amqp.rabbit.support.Delivery;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.amqp.support.ConsumerTagStrategy;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.ObjectUtils;
import org.springframework.util.backoff.BackOffExecution;

public class BlockingQueueConsumer {
    private static Log logger = LogFactory.getLog(BlockingQueueConsumer.class);
    private final BlockingQueue<Delivery> queue;
    private volatile ShutdownSignalException shutdown;
    private final String[] queues;
    private final int prefetchCount;
    private final boolean transactional;
    private Channel channel;
    private RabbitResourceHolder resourceHolder;
    private InternalConsumer consumer;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AcknowledgeMode acknowledgeMode;
    private final ConnectionFactory connectionFactory;
    private final MessagePropertiesConverter messagePropertiesConverter;
    private final ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter;
    private final Map<String, Object> consumerArgs = new HashMap<String, Object>();
    private final boolean noLocal;
    private final boolean exclusive;
    private final Set<Long> deliveryTags = new LinkedHashSet<Long>();
    private final boolean defaultRequeuRejected;
    private final Map<String, String> consumerTags = new ConcurrentHashMap<String, String>();
    private final Set<String> missingQueues = Collections.synchronizedSet(new HashSet());
    private long retryDeclarationInterval = 60000L;
    private long failedDeclarationRetryInterval = 5000L;
    private int declarationRetries = 3;
    private long lastRetryDeclaration;
    private ConsumerTagStrategy tagStrategy;
    private BackOffExecution backOffExecution;
    private long shutdownTimeout;
    private boolean locallyTransacted;
    private ApplicationEventPublisher applicationEventPublisher;
    private volatile long abortStarted;
    private volatile boolean normalCancel;
    volatile Thread thread;
    volatile boolean declaring;

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, String ... queues) {
        this(connectionFactory, messagePropertiesConverter, activeObjectCounter, acknowledgeMode, transactional, prefetchCount, true, queues);
    }

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, boolean defaultRequeueRejected, String ... queues) {
        this(connectionFactory, messagePropertiesConverter, activeObjectCounter, acknowledgeMode, transactional, prefetchCount, defaultRequeueRejected, (Map<String, Object>)null, queues);
    }

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, boolean defaultRequeueRejected, Map<String, Object> consumerArgs, String ... queues) {
        this(connectionFactory, messagePropertiesConverter, activeObjectCounter, acknowledgeMode, transactional, prefetchCount, defaultRequeueRejected, consumerArgs, false, false, queues);
    }

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, boolean defaultRequeueRejected, Map<String, Object> consumerArgs, boolean exclusive, String ... queues) {
        this(connectionFactory, messagePropertiesConverter, activeObjectCounter, acknowledgeMode, transactional, prefetchCount, defaultRequeueRejected, consumerArgs, false, exclusive, queues);
    }

    public BlockingQueueConsumer(ConnectionFactory connectionFactory, MessagePropertiesConverter messagePropertiesConverter, ActiveObjectCounter<BlockingQueueConsumer> activeObjectCounter, AcknowledgeMode acknowledgeMode, boolean transactional, int prefetchCount, boolean defaultRequeueRejected, Map<String, Object> consumerArgs, boolean noLocal, boolean exclusive, String ... queues) {
        this.connectionFactory = connectionFactory;
        this.messagePropertiesConverter = messagePropertiesConverter;
        this.activeObjectCounter = activeObjectCounter;
        this.acknowledgeMode = acknowledgeMode;
        this.transactional = transactional;
        this.prefetchCount = prefetchCount;
        this.defaultRequeuRejected = defaultRequeueRejected;
        if (consumerArgs != null && consumerArgs.size() > 0) {
            this.consumerArgs.putAll(consumerArgs);
        }
        this.noLocal = noLocal;
        this.exclusive = exclusive;
        this.queues = Arrays.copyOf(queues, queues.length);
        this.queue = new LinkedBlockingQueue<Delivery>(prefetchCount);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public String getConsumerTag() {
        return this.consumer.getConsumerTag();
    }

    @Deprecated
    public final void setQuiesce(long shutdownTimeout) {
    }

    public void setShutdownTimeout(long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public void setDeclarationRetries(int declarationRetries) {
        this.declarationRetries = declarationRetries;
    }

    public void setFailedDeclarationRetryInterval(long failedDeclarationRetryInterval) {
        this.failedDeclarationRetryInterval = failedDeclarationRetryInterval;
    }

    public void setRetryDeclarationInterval(long retryDeclarationInterval) {
        this.retryDeclarationInterval = retryDeclarationInterval;
    }

    public void setTagStrategy(ConsumerTagStrategy tagStrategy) {
        this.tagStrategy = tagStrategy;
    }

    public void setBackOffExecution(BackOffExecution backOffExecution) {
        this.backOffExecution = backOffExecution;
    }

    public BackOffExecution getBackOffExecution() {
        return this.backOffExecution;
    }

    public void setLocallyTransacted(boolean locallyTransacted) {
        this.locallyTransacted = locallyTransacted;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void clearDeliveryTags() {
        this.deliveryTags.clear();
    }

    public boolean isNormalCancel() {
        return this.normalCancel;
    }

    int getQueueCount() {
        return this.queues.length;
    }

    protected void basicCancel() {
        this.basicCancel(false);
    }

    protected void basicCancel(boolean expected) {
        this.normalCancel = expected;
        for (String consumerTag : this.consumerTags.keySet()) {
            this.removeConsumer(consumerTag);
            try {
                if (!this.channel.isOpen()) continue;
                this.channel.basicCancel(consumerTag);
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"Error performing 'basicCancel'", (Throwable)e);
            }
            catch (IllegalStateException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"Error performing 'basicCancel'", (Throwable)e);
            }
            catch (AlreadyClosedException e) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)(this.channel + " is already closed"));
            }
        }
        this.abortStarted = System.currentTimeMillis();
    }

    protected boolean hasDelivery() {
        return !this.queue.isEmpty();
    }

    protected boolean cancelled() {
        return this.cancelled.get() || this.abortStarted > 0L && this.abortStarted + this.shutdownTimeout > System.currentTimeMillis() || !this.activeObjectCounter.isActive();
    }

    private void checkShutdown() {
        if (this.shutdown != null) {
            throw (ShutdownSignalException)Utility.fixStackTrace((Throwable)this.shutdown);
        }
    }

    private Message handle(Delivery delivery) throws InterruptedException {
        if (delivery == null && this.shutdown != null) {
            throw this.shutdown;
        }
        if (delivery == null) {
            return null;
        }
        byte[] body = delivery.getBody();
        Envelope envelope = delivery.getEnvelope();
        MessageProperties messageProperties = this.messagePropertiesConverter.toMessageProperties(delivery.getProperties(), envelope, "UTF-8");
        messageProperties.setMessageCount(Integer.valueOf(0));
        messageProperties.setConsumerTag(delivery.getConsumerTag());
        messageProperties.setConsumerQueue(this.consumerTags.get(delivery.getConsumerTag()));
        Message message = new Message(body, messageProperties);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Received message: " + message));
        }
        this.deliveryTags.add(messageProperties.getDeliveryTag());
        if (this.transactional && !this.locallyTransacted) {
            ConnectionFactoryUtils.registerDeliveryTag(this.connectionFactory, this.channel, delivery.getEnvelope().getDeliveryTag());
        }
        return message;
    }

    public Message nextMessage() throws InterruptedException, ShutdownSignalException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Retrieving delivery for " + this));
        }
        return this.handle(this.queue.take());
    }

    public Message nextMessage(long timeout) throws InterruptedException, ShutdownSignalException {
        Message message;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving delivery for " + this));
        }
        this.checkShutdown();
        if (this.missingQueues.size() > 0) {
            this.checkMissingQueues();
        }
        if ((message = this.handle(this.queue.poll(timeout, TimeUnit.MILLISECONDS))) == null && this.cancelled.get()) {
            throw new ConsumerCancelledException();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMissingQueues() {
        long now = System.currentTimeMillis();
        if (now - this.retryDeclarationInterval > this.lastRetryDeclaration) {
            Set<String> set = this.missingQueues;
            synchronized (set) {
                Iterator<String> iterator = this.missingQueues.iterator();
                while (iterator.hasNext()) {
                    boolean available = true;
                    String queue = iterator.next();
                    Channel channel = null;
                    try {
                        channel = this.connectionFactory.createConnection().createChannel(false);
                        channel.queueDeclarePassive(queue);
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Queue '" + queue + "' is now available"));
                        }
                    }
                    catch (IOException e) {
                        available = false;
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)("Queue '" + queue + "' is still not available"));
                        }
                    }
                    finally {
                        if (channel != null) {
                            try {
                                channel.close();
                            }
                            catch (IOException e) {
                            }
                            catch (TimeoutException e) {}
                        }
                    }
                    if (!available) continue;
                    try {
                        this.consumeFromQueue(queue);
                        iterator.remove();
                    }
                    catch (IOException e) {
                        throw RabbitExceptionTranslator.convertRabbitAccessException(e);
                    }
                }
            }
            this.lastRetryDeclaration = now;
        }
    }

    public void start() throws AmqpException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Starting consumer " + this));
        }
        this.thread = Thread.currentThread();
        try {
            this.resourceHolder = ConnectionFactoryUtils.getTransactionalResourceHolder(this.connectionFactory, this.transactional);
            this.channel = this.resourceHolder.getChannel();
            ClosingRecoveryListener.addRecoveryListenerIfNecessary(this.channel);
        }
        catch (AmqpAuthenticationException e) {
            throw new FatalListenerStartupException("Authentication failure", e);
        }
        this.consumer = new InternalConsumer(this.channel);
        this.deliveryTags.clear();
        this.activeObjectCounter.add(this);
        int passiveDeclareRetries = this.declarationRetries;
        this.declaring = true;
        while (!this.cancelled()) {
            block19: {
                try {
                    this.attemptPassiveDeclarations();
                    if (passiveDeclareRetries < this.declarationRetries && logger.isInfoEnabled()) {
                        logger.info((Object)"Queue declaration succeeded after retrying");
                    }
                    passiveDeclareRetries = 0;
                }
                catch (DeclarationException e) {
                    if (passiveDeclareRetries > 0 && this.channel.isOpen()) {
                        if (!logger.isWarnEnabled()) break block19;
                        logger.warn((Object)("Queue declaration failed; retries left=" + passiveDeclareRetries), (Throwable)((Object)e));
                        try {
                            Thread.sleep(this.failedDeclarationRetryInterval);
                        }
                        catch (InterruptedException e1) {
                            this.declaring = false;
                            Thread.currentThread().interrupt();
                            this.activeObjectCounter.release(this);
                            throw RabbitExceptionTranslator.convertRabbitAccessException(e1);
                        }
                    }
                    if (e.getFailedQueues().size() < this.queues.length) {
                        if (logger.isWarnEnabled()) {
                            logger.warn((Object)("Not all queues are available; only listening on those that are - configured: " + Arrays.asList(this.queues) + "; not available: " + e.getFailedQueues()));
                        }
                        this.missingQueues.addAll(e.getFailedQueues());
                        this.lastRetryDeclaration = System.currentTimeMillis();
                    }
                    this.declaring = false;
                    this.activeObjectCounter.release(this);
                    throw new QueuesNotAvailableException("Cannot prepare queue for listener. Either the queue doesn't exist or the broker will not allow us to use it.", (Throwable)((Object)e));
                }
            }
            if (passiveDeclareRetries-- > 0 && !this.cancelled()) continue;
        }
        this.declaring = false;
        if (!this.acknowledgeMode.isAutoAck() && !this.cancelled()) {
            try {
                this.channel.basicQos(this.prefetchCount);
            }
            catch (IOException e) {
                this.activeObjectCounter.release(this);
                throw new AmqpIOException(e);
            }
        }
        try {
            if (!this.cancelled()) {
                for (String queueName : this.queues) {
                    if (this.missingQueues.contains(queueName)) continue;
                    this.consumeFromQueue(queueName);
                }
            }
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    private void consumeFromQueue(String queue) throws IOException {
        String consumerTag = this.channel.basicConsume(queue, this.acknowledgeMode.isAutoAck(), this.tagStrategy != null ? this.tagStrategy.createConsumerTag(queue) : "", this.noLocal, this.exclusive, this.consumerArgs, (Consumer)new ConsumerDecorator(queue, (Consumer)this.consumer, this.applicationEventPublisher));
        if (consumerTag != null) {
            this.consumerTags.put(consumerTag, queue);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Started on queue '" + queue + "' with tag " + consumerTag + ": " + this));
            }
        } else {
            logger.error((Object)("Null consumer tag received for queue " + queue));
        }
    }

    private void attemptPassiveDeclarations() {
        DeclarationException failures = null;
        for (String queueName : this.queues) {
            try {
                try {
                    this.channel.queueDeclarePassive(queueName);
                }
                catch (IllegalArgumentException e) {
                    try {
                        if (this.channel instanceof ChannelProxy) {
                            ((ChannelProxy)this.channel).getTargetChannel().close();
                        }
                    }
                    catch (TimeoutException timeoutException) {
                        // empty catch block
                    }
                    throw new FatalListenerStartupException("Illegal Argument on Queue Declaration", e);
                }
            }
            catch (IOException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Failed to declare queue: " + queueName));
                }
                if (!this.channel.isOpen()) {
                    throw new AmqpIOException(e);
                }
                if (failures == null) {
                    failures = new DeclarationException(e);
                }
                failures.addFailedQueue(queueName);
            }
        }
        if (failures != null) {
            throw failures;
        }
    }

    public void stop() {
        block5: {
            if (this.abortStarted == 0L) {
                this.abortStarted = System.currentTimeMillis();
            }
            if (this.consumer != null && this.consumer.getChannel() != null && this.consumerTags.size() > 0 && !this.cancelled.get()) {
                try {
                    RabbitUtils.closeMessageConsumer(this.consumer.getChannel(), this.consumerTags.keySet(), this.transactional);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block5;
                    logger.debug((Object)("Error closing consumer " + this), (Throwable)e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Closing Rabbit Channel: " + this.channel));
        }
        RabbitUtils.setPhysicalCloseRequired(this.channel, true);
        ConnectionFactoryUtils.releaseResources(this.resourceHolder);
        this.deliveryTags.clear();
        this.consumer = null;
        this.queue.clear();
    }

    public void rollbackOnExceptionIfNecessary(Throwable ex) throws Exception {
        boolean ackRequired = !this.acknowledgeMode.isAutoAck() && !this.acknowledgeMode.isManual();
        try {
            if (this.transactional) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Initiating transaction rollback on application exception: " + ex));
                }
                RabbitUtils.rollbackIfNecessary(this.channel);
            }
            if (ackRequired) {
                boolean shouldRequeue = RabbitUtils.shouldRequeue(this.defaultRequeuRejected, ex, logger);
                for (Long deliveryTag : this.deliveryTags) {
                    this.channel.basicReject(deliveryTag.longValue(), shouldRequeue);
                }
                if (this.transactional) {
                    RabbitUtils.commitIfNecessary(this.channel);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Application exception overridden by rollback exception", ex);
            throw e;
        }
        finally {
            this.deliveryTags.clear();
        }
    }

    private boolean removeConsumer(String consumerTag) {
        this.consumerTags.remove(consumerTag);
        if (this.consumerTags.isEmpty()) {
            this.cancelled.set(true);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitIfNecessary(boolean locallyTransacted) throws IOException {
        if (this.deliveryTags.isEmpty()) {
            return false;
        }
        boolean isLocallyTransacted = locallyTransacted || this.transactional && TransactionSynchronizationManager.getResource((Object)this.connectionFactory) == null;
        try {
            boolean ackRequired;
            boolean bl = ackRequired = !this.acknowledgeMode.isAutoAck() && !this.acknowledgeMode.isManual();
            if (ackRequired && (!this.transactional || isLocallyTransacted)) {
                long deliveryTag = new ArrayList<Long>(this.deliveryTags).get(this.deliveryTags.size() - 1);
                this.channel.basicAck(deliveryTag, true);
            }
            if (isLocallyTransacted) {
                RabbitUtils.commitIfNecessary(this.channel);
            }
        }
        finally {
            this.deliveryTags.clear();
        }
        return true;
    }

    public String toString() {
        return "Consumer@" + ObjectUtils.getIdentityHexString((Object)this) + ": tags=[" + this.consumerTags.toString() + "], channel=" + this.channel + ", acknowledgeMode=" + this.acknowledgeMode + " local queue size=" + this.queue.size();
    }

    private static final class DeclarationException
    extends AmqpException {
        private final List<String> failedQueues = new ArrayList<String>();

        private DeclarationException() {
            super("Failed to declare queue(s):");
        }

        private DeclarationException(Throwable t) {
            super("Failed to declare queue(s):", t);
        }

        private void addFailedQueue(String queue) {
            this.failedQueues.add(queue);
        }

        private List<String> getFailedQueues() {
            return this.failedQueues;
        }

        public String getMessage() {
            return super.getMessage() + this.failedQueues.toString();
        }
    }

    private static final class ConsumerDecorator
    implements Consumer {
        private final String queue;
        private final Consumer delegate;
        private final ApplicationEventPublisher applicationEventPublisher;
        private String consumerTag;

        ConsumerDecorator(String queue, Consumer delegate, ApplicationEventPublisher applicationEventPublisher) {
            this.queue = queue;
            this.delegate = delegate;
            this.applicationEventPublisher = applicationEventPublisher;
        }

        public void handleConsumeOk(String consumerTag) {
            this.consumerTag = consumerTag;
            this.delegate.handleConsumeOk(consumerTag);
            if (this.applicationEventPublisher != null) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new ConsumeOkEvent(this.delegate, this.queue, consumerTag));
            }
        }

        public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
            this.delegate.handleShutdownSignal(consumerTag, sig);
        }

        public void handleCancel(String consumerTag) throws IOException {
            this.delegate.handleCancel(consumerTag);
        }

        public void handleCancelOk(String consumerTag) {
            this.delegate.handleCancelOk(consumerTag);
        }

        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            this.delegate.handleDelivery(consumerTag, envelope, properties, body);
        }

        public void handleRecoverOk(String consumerTag) {
            this.delegate.handleRecoverOk(consumerTag);
        }

        public String toString() {
            return "ConsumerDecorator{queue='" + this.queue + '\'' + ", consumerTag='" + this.consumerTag + '\'' + '}';
        }
    }

    private final class InternalConsumer
    extends DefaultConsumer {
        private InternalConsumer(Channel channel) {
            super(channel);
        }

        public void handleConsumeOk(String consumerTag) {
            super.handleConsumeOk(consumerTag);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ConsumeOK: " + BlockingQueueConsumer.this));
            }
        }

        public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
            if (logger.isDebugEnabled()) {
                if (RabbitUtils.isNormalShutdown(sig)) {
                    logger.debug((Object)("Received shutdown signal for consumer tag=" + consumerTag + ": " + sig.getMessage()));
                } else {
                    logger.debug((Object)("Received shutdown signal for consumer tag=" + consumerTag), (Throwable)sig);
                }
            }
            BlockingQueueConsumer.this.shutdown = sig;
            BlockingQueueConsumer.this.deliveryTags.clear();
            BlockingQueueConsumer.this.activeObjectCounter.release(BlockingQueueConsumer.this);
        }

        public void handleCancel(String consumerTag) throws IOException {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("Cancel received for " + consumerTag + " (" + (String)BlockingQueueConsumer.this.consumerTags.get(consumerTag) + "); " + BlockingQueueConsumer.this));
            }
            if (BlockingQueueConsumer.this.removeConsumer(consumerTag)) {
                BlockingQueueConsumer.this.basicCancel(false);
            }
        }

        public void handleCancelOk(String consumerTag) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Received cancelOk for tag " + consumerTag + " (" + (String)BlockingQueueConsumer.this.consumerTags.get(consumerTag) + "); " + BlockingQueueConsumer.this));
            }
        }

        public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Storing delivery for consumerTag: '" + consumerTag + "' with deliveryTag: '" + envelope.getDeliveryTag() + "' in " + BlockingQueueConsumer.this));
            }
            try {
                if (BlockingQueueConsumer.this.abortStarted > 0L) {
                    if (!BlockingQueueConsumer.this.queue.offer(new Delivery(consumerTag, envelope, properties, body), BlockingQueueConsumer.this.shutdownTimeout, TimeUnit.MILLISECONDS)) {
                        RabbitUtils.setPhysicalCloseRequired(this.getChannel(), true);
                        BlockingQueueConsumer.this.queue.clear();
                        this.getChannel().basicNack(envelope.getDeliveryTag(), true, true);
                        this.getChannel().basicCancel(consumerTag);
                        try {
                            this.getChannel().close();
                        }
                        catch (TimeoutException timeoutException) {}
                    }
                } else {
                    BlockingQueueConsumer.this.queue.put(new Delivery(consumerTag, envelope, properties, body));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

