/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Recoverable;
import com.rabbitmq.client.RecoveryListener;
import com.rabbitmq.client.impl.recovery.AutorecoveringConnection;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.rabbit.connection.ChannelListener;
import org.springframework.amqp.rabbit.connection.CompositeChannelListener;
import org.springframework.amqp.rabbit.connection.CompositeConnectionListener;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.ConnectionNameStrategy;
import org.springframework.amqp.rabbit.connection.SimpleConnection;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractConnectionFactory
implements ConnectionFactory,
DisposableBean,
BeanNameAware {
    private static final String BAD_URI = "setUri() was passed an invalid URI; it is ignored";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory;
    private final CompositeConnectionListener connectionListener = new CompositeConnectionListener();
    private final CompositeChannelListener channelListener = new CompositeChannelListener();
    private final AtomicInteger defaultConnectionNameStrategyCounter = new AtomicInteger();
    private RecoveryListener recoveryListener = new RecoveryListener(){

        public void handleRecoveryStarted(Recoverable recoverable) {
            if (AbstractConnectionFactory.this.logger.isDebugEnabled()) {
                AbstractConnectionFactory.this.logger.debug((Object)("Connection recovery started: " + recoverable));
            }
        }

        public void handleRecovery(Recoverable recoverable) {
            if (AbstractConnectionFactory.this.logger.isDebugEnabled()) {
                AbstractConnectionFactory.this.logger.debug((Object)("Connection recovery complete: " + recoverable));
            }
        }
    };
    private volatile ExecutorService executorService;
    private volatile Address[] addresses;
    public static final int DEFAULT_CLOSE_TIMEOUT = 30000;
    private volatile int closeTimeout = 30000;
    private ConnectionNameStrategy connectionNameStrategy = new ConnectionNameStrategy(){

        @Override
        public String obtainNewConnectionName(ConnectionFactory connectionFactory) {
            return (AbstractConnectionFactory.this.beanName != null ? AbstractConnectionFactory.this.beanName : "SpringAMQP") + "#" + ObjectUtils.getIdentityHexString((Object)this) + ":" + AbstractConnectionFactory.this.defaultConnectionNameStrategyCounter.getAndIncrement();
        }
    };
    private volatile String beanName;

    public AbstractConnectionFactory(com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory) {
        Assert.notNull((Object)rabbitConnectionFactory, (String)"Target ConnectionFactory must not be null");
        this.rabbitConnectionFactory = rabbitConnectionFactory;
    }

    public com.rabbitmq.client.ConnectionFactory getRabbitConnectionFactory() {
        return this.rabbitConnectionFactory;
    }

    @Override
    public String getUsername() {
        return this.rabbitConnectionFactory.getUsername();
    }

    public void setUsername(String username) {
        this.rabbitConnectionFactory.setUsername(username);
    }

    public void setPassword(String password) {
        this.rabbitConnectionFactory.setPassword(password);
    }

    public void setHost(String host) {
        this.rabbitConnectionFactory.setHost(host);
    }

    public void setConnectionThreadFactory(ThreadFactory threadFactory) {
        this.rabbitConnectionFactory.setThreadFactory(threadFactory);
    }

    public void setUri(URI uri) {
        try {
            this.rabbitConnectionFactory.setUri(uri);
        }
        catch (URISyntaxException use) {
            this.logger.info((Object)BAD_URI, (Throwable)use);
        }
        catch (GeneralSecurityException gse) {
            this.logger.info((Object)BAD_URI, (Throwable)gse);
        }
    }

    public void setUri(String uri) {
        try {
            this.rabbitConnectionFactory.setUri(uri);
        }
        catch (URISyntaxException use) {
            this.logger.info((Object)BAD_URI, (Throwable)use);
        }
        catch (GeneralSecurityException gse) {
            this.logger.info((Object)BAD_URI, (Throwable)gse);
        }
    }

    @Override
    public String getHost() {
        return this.rabbitConnectionFactory.getHost();
    }

    public void setVirtualHost(String virtualHost) {
        this.rabbitConnectionFactory.setVirtualHost(virtualHost);
    }

    @Override
    public String getVirtualHost() {
        return this.rabbitConnectionFactory.getVirtualHost();
    }

    public void setPort(int port) {
        this.rabbitConnectionFactory.setPort(port);
    }

    public void setRequestedHeartBeat(int requestedHeartBeat) {
        this.rabbitConnectionFactory.setRequestedHeartbeat(requestedHeartBeat);
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.rabbitConnectionFactory.setConnectionTimeout(connectionTimeout);
    }

    @Override
    public int getPort() {
        return this.rabbitConnectionFactory.getPort();
    }

    public void setAddresses(String addresses) {
        Address[] addressArray;
        if (StringUtils.hasText((String)addresses) && (addressArray = Address.parseAddresses((String)addresses)).length > 0) {
            this.addresses = addressArray;
            return;
        }
        this.logger.info((Object)"setAddresses() called with an empty value, will be using the host+port properties for connections");
        this.addresses = null;
    }

    protected ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    protected ChannelListener getChannelListener() {
        return this.channelListener;
    }

    public void setConnectionListeners(List<? extends ConnectionListener> listeners) {
        this.connectionListener.setDelegates(listeners);
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListener.addDelegate(listener);
    }

    @Override
    public boolean removeConnectionListener(ConnectionListener listener) {
        return this.connectionListener.removeDelegate(listener);
    }

    @Override
    public void clearConnectionListeners() {
        this.connectionListener.clearDelegates();
    }

    public void setChannelListeners(List<? extends ChannelListener> listeners) {
        this.channelListener.setDelegates(listeners);
    }

    public void addChannelListener(ChannelListener listener) {
        this.channelListener.addDelegate(listener);
    }

    public void setRecoveryListener(RecoveryListener recoveryListener) {
        this.recoveryListener = recoveryListener;
    }

    public void setExecutor(Executor executor) {
        boolean isExecutorService = executor instanceof ExecutorService;
        boolean isThreadPoolTaskExecutor = executor instanceof ThreadPoolTaskExecutor;
        Assert.isTrue((isExecutorService || isThreadPoolTaskExecutor ? 1 : 0) != 0, (String)"The executor must be an 'ExecutorService' or a 'ThreadPoolTaskExecutor'");
        this.executorService = isExecutorService ? (ExecutorService)executor : ((ThreadPoolTaskExecutor)executor).getThreadPoolExecutor();
    }

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public int getCloseTimeout() {
        return this.closeTimeout;
    }

    public void setConnectionNameStrategy(ConnectionNameStrategy connectionNameStrategy) {
        this.connectionNameStrategy = connectionNameStrategy;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    protected final Connection createBareConnection() {
        try {
            com.rabbitmq.client.Connection rabbitConnection;
            String connectionName;
            String string = connectionName = this.connectionNameStrategy == null ? null : this.connectionNameStrategy.obtainNewConnectionName(this);
            if (this.addresses != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Attempting to connect to: " + Arrays.toString(this.addresses)));
                }
                rabbitConnection = this.rabbitConnectionFactory.newConnection(this.executorService, this.addresses, connectionName);
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Attempting to connect to: " + this.rabbitConnectionFactory.getHost() + ":" + this.rabbitConnectionFactory.getPort()));
                }
                rabbitConnection = this.rabbitConnectionFactory.newConnection(this.executorService, connectionName);
            }
            SimpleConnection connection = new SimpleConnection(rabbitConnection, this.closeTimeout);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Created new connection: " + connectionName + "/" + connection));
            }
            if (this.recoveryListener != null && rabbitConnection instanceof AutorecoveringConnection) {
                ((AutorecoveringConnection)rabbitConnection).addRecoveryListener(this.recoveryListener);
            }
            return connection;
        }
        catch (IOException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
        catch (TimeoutException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    protected final String getDefaultHostName() {
        String temp;
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            temp = localMachine.getHostName();
            this.logger.debug((Object)("Using hostname [" + temp + "] for hostname."));
        }
        catch (UnknownHostException e) {
            this.logger.warn((Object)"Could not get host name, using 'localhost' as default value", (Throwable)e);
            temp = "localhost";
        }
        return temp;
    }

    public void destroy() {
    }

    public String toString() {
        if (this.beanName != null) {
            return this.beanName;
        }
        return super.toString();
    }
}

