/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import com.rabbitmq.client.ConnectionFactory;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Calendar;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.core.DeclareExchangeConnectionListener;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.LogAppenderUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AmqpAppender
extends AppenderBase<ILoggingEvent> {
    public static final String APPLICATION_ID = "applicationId";
    public static final String CATEGORY_NAME = "categoryName";
    public static final String CATEGORY_LEVEL = "level";
    public static final String THREAD_NAME = "thread";
    private String exchangeName = "logs";
    private String exchangeType = "topic";
    private final PatternLayout locationLayout = new PatternLayout();
    private final PatternLayout routingKeyLayout;
    private final AtomicBoolean headerWritten;
    private String applicationId;
    private final LinkedBlockingQueue<Event> events;
    private ExecutorService senderPool;
    private int senderPoolSize;
    private int maxSenderRetries;
    private final Timer retryTimer;
    private AbstractConnectionFactory connectionFactory;
    private String clientConnectionProperties;
    private String addresses;
    private URI uri;
    private String host;
    private String virtualHost;
    private Integer port;
    private String username;
    private String password;
    private boolean useSsl;
    private String sslAlgorithm;
    private String sslPropertiesLocation;
    private String keyStore;
    private String keyStorePassphrase;
    private String keyStoreType;
    private String trustStore;
    private String trustStorePassphrase;
    private String trustStoreType;
    private String contentType;
    private String contentEncoding;
    private boolean declareExchange;
    private String charset;
    private boolean durable;
    private MessageDeliveryMode deliveryMode;
    private boolean autoDelete;
    private boolean generateId;
    private Layout<ILoggingEvent> layout;
    private Encoder<ILoggingEvent> encoder;
    private TargetLengthBasedClassNameAbbreviator abbreviator;
    private boolean includeCallerData;

    public AmqpAppender() {
        this.locationLayout.setPattern("%nopex%class|%method|%line");
        this.routingKeyLayout = new PatternLayout();
        this.routingKeyLayout.setPattern("%nopex%c.%p");
        this.headerWritten = new AtomicBoolean();
        this.applicationId = null;
        this.events = new LinkedBlockingQueue();
        this.senderPool = null;
        this.senderPoolSize = 2;
        this.maxSenderRetries = 30;
        this.retryTimer = new Timer("log-event-retry-delay", true);
        this.keyStoreType = "JKS";
        this.trustStoreType = "JKS";
        this.contentType = "text/plain";
        this.contentEncoding = null;
        this.declareExchange = false;
        this.durable = true;
        this.deliveryMode = MessageDeliveryMode.PERSISTENT;
        this.autoDelete = false;
        this.generateId = false;
    }

    public void setRoutingKeyPattern(String routingKeyPattern) {
        this.routingKeyLayout.setPattern("%nopex{}" + routingKeyPattern);
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }

    public String getAddresses() {
        return this.addresses;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean ssl) {
        this.useSsl = ssl;
    }

    public String getSslAlgorithm() {
        return this.sslAlgorithm;
    }

    public void setSslAlgorithm(String sslAlgorithm) {
        this.sslAlgorithm = sslAlgorithm;
    }

    public String getSslPropertiesLocation() {
        return this.sslPropertiesLocation;
    }

    public void setSslPropertiesLocation(String sslPropertiesLocation) {
        this.sslPropertiesLocation = sslPropertiesLocation;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public String getKeyStorePassphrase() {
        return this.keyStorePassphrase;
    }

    public void setKeyStorePassphrase(String keyStorePassphrase) {
        this.keyStorePassphrase = keyStorePassphrase;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public String getTrustStorePassphrase() {
        return this.trustStorePassphrase;
    }

    public void setTrustStorePassphrase(String trustStorePassphrase) {
        this.trustStorePassphrase = trustStorePassphrase;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public void setExchangeName(String exchangeName) {
        this.exchangeName = exchangeName;
    }

    public String getExchangeType() {
        return this.exchangeType;
    }

    public void setExchangeType(String exchangeType) {
        this.exchangeType = exchangeType;
    }

    public String getRoutingKeyPattern() {
        return this.routingKeyLayout.getPattern();
    }

    public boolean isDeclareExchange() {
        return this.declareExchange;
    }

    public void setDeclareExchange(boolean declareExchange) {
        this.declareExchange = declareExchange;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public int getSenderPoolSize() {
        return this.senderPoolSize;
    }

    public void setSenderPoolSize(int senderPoolSize) {
        this.senderPoolSize = senderPoolSize;
    }

    public int getMaxSenderRetries() {
        return this.maxSenderRetries;
    }

    public void setMaxSenderRetries(int maxSenderRetries) {
        this.maxSenderRetries = maxSenderRetries;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public String getDeliveryMode() {
        return this.deliveryMode.toString();
    }

    public void setDeliveryMode(String deliveryMode) {
        this.deliveryMode = MessageDeliveryMode.valueOf((String)deliveryMode);
    }

    public boolean isAutoDelete() {
        return this.autoDelete;
    }

    public void setAutoDelete(boolean autoDelete) {
        this.autoDelete = autoDelete;
    }

    public boolean isGenerateId() {
        return this.generateId;
    }

    public void setGenerateId(boolean generateId) {
        this.generateId = generateId;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public Encoder<ILoggingEvent> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    public void setAbbreviation(int len) {
        this.abbreviator = new TargetLengthBasedClassNameAbbreviator(len);
    }

    public int getQueuedEventCount() {
        return this.events.size();
    }

    public void setClientConnectionProperties(String clientConnectionProperties) {
        this.clientConnectionProperties = clientConnectionProperties;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }

    public void start() {
        ConnectionFactory rabbitConnectionFactory = this.createRabbitConnectionFactory();
        if (rabbitConnectionFactory != null) {
            super.start();
            this.routingKeyLayout.setPattern(this.routingKeyLayout.getPattern().replaceAll("%property\\{applicationId\\}", this.applicationId));
            this.routingKeyLayout.setContext(this.getContext());
            this.routingKeyLayout.start();
            this.locationLayout.setContext(this.getContext());
            this.locationLayout.start();
            this.connectionFactory = new CachingConnectionFactory(rabbitConnectionFactory);
            if (this.addresses != null) {
                this.connectionFactory.setAddresses(this.addresses);
            }
            LogAppenderUtils.updateClientConnectionProperties(this.connectionFactory, this.clientConnectionProperties);
            this.updateConnectionClientProperties(this.connectionFactory.getRabbitConnectionFactory().getClientProperties());
            this.setUpExchangeDeclaration();
            this.senderPool = Executors.newCachedThreadPool();
            for (int i = 0; i < this.senderPoolSize; ++i) {
                this.senderPool.submit(new EventSender());
            }
        }
    }

    protected ConnectionFactory createRabbitConnectionFactory() {
        RabbitConnectionFactoryBean factoryBean = new RabbitConnectionFactoryBean();
        this.configureRabbitConnectionFactory(factoryBean);
        try {
            factoryBean.afterPropertiesSet();
            return (ConnectionFactory)factoryBean.getObject();
        }
        catch (Exception e) {
            this.addError("Failed to create customized Rabbit ConnectionFactory.", e);
            return null;
        }
    }

    protected void configureRabbitConnectionFactory(RabbitConnectionFactoryBean factoryBean) {
        Optional.ofNullable(this.host).ifPresent(factoryBean::setHost);
        Optional.ofNullable(this.port).ifPresent(factoryBean::setPort);
        Optional.ofNullable(this.username).ifPresent(factoryBean::setUsername);
        Optional.ofNullable(this.password).ifPresent(factoryBean::setPassword);
        Optional.ofNullable(this.virtualHost).ifPresent(factoryBean::setVirtualHost);
        Optional.ofNullable(this.uri).ifPresent(factoryBean::setUri);
        if (this.useSsl) {
            factoryBean.setUseSSL(true);
            if (this.sslAlgorithm != null) {
                factoryBean.setSslAlgorithm(this.sslAlgorithm);
            }
            if (this.sslPropertiesLocation != null) {
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                Resource sslPropertiesResource = resolver.getResource(this.sslPropertiesLocation);
                factoryBean.setSslPropertiesLocation(sslPropertiesResource);
            } else {
                factoryBean.setKeyStore(this.keyStore);
                factoryBean.setKeyStorePassphrase(this.keyStorePassphrase);
                factoryBean.setKeyStoreType(this.keyStoreType);
                factoryBean.setTrustStore(this.trustStore);
                factoryBean.setTrustStorePassphrase(this.trustStorePassphrase);
                factoryBean.setTrustStoreType(this.trustStoreType);
            }
        }
        if (this.layout == null && this.encoder == null) {
            this.addError("Either a layout or encoder is required");
        }
        if (this.layout != null && this.encoder != null) {
            this.addError("Only one of layout or encoder is possible");
        }
    }

    protected void updateConnectionClientProperties(Map<String, Object> clientProperties) {
    }

    public void stop() {
        super.stop();
        if (null != this.senderPool) {
            this.senderPool.shutdownNow();
            this.senderPool = null;
        }
        if (null != this.connectionFactory) {
            this.connectionFactory.destroy();
        }
        this.retryTimer.cancel();
        this.routingKeyLayout.stop();
    }

    protected void append(ILoggingEvent event) {
        if (this.isIncludeCallerData()) {
            event.getCallerData();
        }
        event.getThreadName();
        this.events.add(new Event(event));
    }

    protected void setUpExchangeDeclaration() {
        RabbitAdmin admin = new RabbitAdmin(this.connectionFactory);
        if (this.declareExchange) {
            Object x = "topic".equals(this.exchangeType) ? new TopicExchange(this.exchangeName, this.durable, this.autoDelete) : ("direct".equals(this.exchangeType) ? new DirectExchange(this.exchangeName, this.durable, this.autoDelete) : ("fanout".equals(this.exchangeType) ? new FanoutExchange(this.exchangeName, this.durable, this.autoDelete) : ("headers".equals(this.exchangeType) ? new HeadersExchange(this.exchangeType, this.durable, this.autoDelete) : new TopicExchange(this.exchangeName, this.durable, this.autoDelete))));
            this.connectionFactory.addConnectionListener(new DeclareExchangeConnectionListener((Exchange)x, admin));
        }
    }

    public Message postProcessMessageBeforeSend(Message message, Event event) {
        return message;
    }

    protected static class Event {
        private final ILoggingEvent event;
        private final Map<String, String> properties;
        private final AtomicInteger retries = new AtomicInteger(0);

        public Event(ILoggingEvent event) {
            this.event = event;
            this.properties = this.event.getMDCPropertyMap();
        }

        public ILoggingEvent getEvent() {
            return this.event;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public int incrementRetries() {
            return this.retries.incrementAndGet();
        }
    }

    protected class EventSender
    implements Runnable {
        protected EventSender() {
        }

        @Override
        public void run() {
            try {
                RabbitTemplate rabbitTemplate = new RabbitTemplate(AmqpAppender.this.connectionFactory);
                while (true) {
                    byte[] msgBody;
                    byte[] header;
                    final Event event = (Event)AmqpAppender.this.events.take();
                    ILoggingEvent logEvent = event.getEvent();
                    String name = logEvent.getLoggerName();
                    Level level = logEvent.getLevel();
                    MessageProperties amqpProps = new MessageProperties();
                    amqpProps.setDeliveryMode(AmqpAppender.this.deliveryMode);
                    amqpProps.setContentType(AmqpAppender.this.contentType);
                    if (null != AmqpAppender.this.contentEncoding) {
                        amqpProps.setContentEncoding(AmqpAppender.this.contentEncoding);
                    }
                    amqpProps.setHeader(AmqpAppender.CATEGORY_NAME, (Object)name);
                    amqpProps.setHeader(AmqpAppender.THREAD_NAME, (Object)logEvent.getThreadName());
                    amqpProps.setHeader(AmqpAppender.CATEGORY_LEVEL, (Object)level.toString());
                    if (AmqpAppender.this.generateId) {
                        amqpProps.setMessageId(UUID.randomUUID().toString());
                    }
                    Calendar tstamp = Calendar.getInstance();
                    tstamp.setTimeInMillis(logEvent.getTimeStamp());
                    amqpProps.setTimestamp(tstamp.getTime());
                    Map<String, String> props = event.getProperties();
                    Set<Map.Entry<String, String>> entrySet = props.entrySet();
                    for (Map.Entry<String, String> entry : entrySet) {
                        amqpProps.setHeader(entry.getKey(), (Object)entry.getValue());
                    }
                    String[] location = AmqpAppender.this.locationLayout.doLayout(logEvent).split("\\|");
                    if (!"?".equals(location[0])) {
                        amqpProps.setHeader("location", (Object)String.format("%s.%s()[%s]", location[0], location[1], location[2]));
                    }
                    String routingKey = AmqpAppender.this.routingKeyLayout.doLayout(logEvent);
                    if (AmqpAppender.this.applicationId != null) {
                        amqpProps.setAppId(AmqpAppender.this.applicationId);
                    }
                    if (AmqpAppender.this.encoder != null && AmqpAppender.this.headerWritten.compareAndSet(false, true) && (header = AmqpAppender.this.encoder.headerBytes()) != null && header.length > 0) {
                        rabbitTemplate.convertAndSend(AmqpAppender.this.exchangeName, routingKey, (Object)header, m -> {
                            if (AmqpAppender.this.applicationId != null) {
                                m.getMessageProperties().setAppId(AmqpAppender.this.applicationId);
                            }
                            return m;
                        });
                    }
                    if (AmqpAppender.this.abbreviator != null && logEvent instanceof LoggingEvent) {
                        ((LoggingEvent)logEvent).setLoggerName(AmqpAppender.this.abbreviator.abbreviate(name));
                        msgBody = this.encodeMessage(logEvent);
                        ((LoggingEvent)logEvent).setLoggerName(name);
                    } else {
                        msgBody = this.encodeMessage(logEvent);
                    }
                    try {
                        Message message = new Message(msgBody, amqpProps);
                        message = AmqpAppender.this.postProcessMessageBeforeSend(message, event);
                        rabbitTemplate.send(AmqpAppender.this.exchangeName, routingKey, message);
                    }
                    catch (AmqpException e) {
                        int retries = event.incrementRetries();
                        if (retries < AmqpAppender.this.maxSenderRetries) {
                            AmqpAppender.this.retryTimer.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    AmqpAppender.this.events.add(event);
                                }
                            }, (long)(Math.pow(retries, Math.log(retries)) * 1000.0));
                            continue;
                        }
                        AmqpAppender.this.addError("Could not send log message " + logEvent.getMessage() + " after " + AmqpAppender.this.maxSenderRetries + " retries", e);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }

        private byte[] encodeMessage(ILoggingEvent logEvent) {
            if (AmqpAppender.this.encoder != null) {
                return AmqpAppender.this.encoder.encode((Object)logEvent);
            }
            String msgBody = AmqpAppender.this.layout.doLayout((Object)logEvent);
            if (AmqpAppender.this.charset != null) {
                try {
                    return msgBody.getBytes(AmqpAppender.this.charset);
                }
                catch (UnsupportedEncodingException e) {
                    return msgBody.getBytes();
                }
            }
            return msgBody.getBytes();
        }
    }
}

