/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.transaction;

import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class RabbitTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager,
InitializingBean {
    private ConnectionFactory connectionFactory;

    public RabbitTransactionManager() {
        this.setTransactionSynchronization(2);
    }

    public RabbitTransactionManager(ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"'connectionFactory' cannot be null");
        this.connectionFactory = connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void afterPropertiesSet() {
        Assert.state((this.getConnectionFactory() == null ? 1 : 0) != 0, (String)"Property 'connectionFactory' is required");
    }

    public Object getResourceFactory() {
        return this.getConnectionFactory();
    }

    protected Object doGetTransaction() {
        RabbitTransactionObject txObject = new RabbitTransactionObject();
        txObject.setResourceHolder((RabbitResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.getConnectionFactory())));
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) {
        RabbitTransactionObject txObject = (RabbitTransactionObject)transaction;
        return txObject.getResourceHolder() != null;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        if (definition.getIsolationLevel() != -1) {
            throw new InvalidIsolationLevelException("AMQP does not support an isolation level concept");
        }
        RabbitTransactionObject txObject = (RabbitTransactionObject)transaction;
        RabbitResourceHolder resourceHolder = null;
        try {
            resourceHolder = ConnectionFactoryUtils.getTransactionalResourceHolder(this.getConnectionFactory(), true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created AMQP transaction on channel [" + resourceHolder.getChannel() + "]"));
            }
            txObject.setResourceHolder(resourceHolder);
            txObject.getResourceHolder().setSynchronizedWithTransaction(true);
            int timeout = this.determineTimeout(definition);
            if (timeout != -1) {
                txObject.getResourceHolder().setTimeoutInSeconds(timeout);
            }
            TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)txObject.getResourceHolder()));
        }
        catch (AmqpException ex) {
            if (resourceHolder != null) {
                ConnectionFactoryUtils.releaseResources(resourceHolder);
            }
            throw new CannotCreateTransactionException("Could not create AMQP transaction", (Throwable)ex);
        }
    }

    protected Object doSuspend(Object transaction) {
        RabbitTransactionObject txObject = (RabbitTransactionObject)transaction;
        txObject.setResourceHolder(null);
        return TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        RabbitResourceHolder conHolder = (RabbitResourceHolder)((Object)suspendedResources);
        TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)conHolder));
    }

    protected void doCommit(DefaultTransactionStatus status) {
        RabbitTransactionObject txObject = (RabbitTransactionObject)status.getTransaction();
        RabbitResourceHolder resourceHolder = txObject.getResourceHolder();
        resourceHolder.commitAll();
    }

    protected void doRollback(DefaultTransactionStatus status) {
        RabbitTransactionObject txObject = (RabbitTransactionObject)status.getTransaction();
        RabbitResourceHolder resourceHolder = txObject.getResourceHolder();
        resourceHolder.rollbackAll();
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        RabbitTransactionObject txObject = (RabbitTransactionObject)status.getTransaction();
        txObject.getResourceHolder().setRollbackOnly();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        RabbitTransactionObject txObject = (RabbitTransactionObject)transaction;
        TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
        txObject.getResourceHolder().closeAll();
        txObject.getResourceHolder().clear();
    }

    private static class RabbitTransactionObject
    implements SmartTransactionObject {
        private RabbitResourceHolder resourceHolder;

        RabbitTransactionObject() {
        }

        public void setResourceHolder(RabbitResourceHolder resourceHolder) {
            this.resourceHolder = resourceHolder;
        }

        public RabbitResourceHolder getResourceHolder() {
            return this.resourceHolder;
        }

        public boolean isRollbackOnly() {
            return this.resourceHolder.isRollbackOnly();
        }

        public void flush() {
        }
    }
}

