/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.log4j2;

import com.rabbitmq.client.ConnectionFactory;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.async.BlockingQueueFactory;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Integers;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.FanoutExchange;
import org.springframework.amqp.core.HeadersExchange;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryConfigurationUtils;
import org.springframework.amqp.rabbit.connection.RabbitConnectionFactoryBean;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.core.DeclareExchangeConnectionListener;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.amqp.utils.JavaUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Plugin(name="RabbitMQ", category="Core", elementType="appender", printObject=true)
public class AmqpAppender
extends AbstractAppender {
    public static final String APPLICATION_ID = "applicationId";
    public static final String CATEGORY_NAME = "categoryName";
    public static final String CATEGORY_LEVEL = "level";
    public static final String THREAD_NAME = "thread";
    private final AmqpManager manager;
    private final RabbitTemplate rabbitTemplate = new RabbitTemplate();
    private final BlockingQueue<Event> events;
    private final Object layoutMutex = new Object();

    public AmqpAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, AmqpManager manager, BlockingQueue<Event> eventQueue) {
        super(name, filter, layout, ignoreExceptions);
        this.manager = manager;
        this.events = eventQueue;
    }

    @PluginFactory
    public static AmqpAppender createAppender(@PluginConfiguration Configuration configuration, @PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions, @PluginAttribute(value="uri") URI uri, @PluginAttribute(value="host") String host, @PluginAttribute(value="port") String port, @PluginAttribute(value="addresses") String addresses, @PluginAttribute(value="user") String user, @PluginAttribute(value="password") String password, @PluginAttribute(value="virtualHost") String virtualHost, @PluginAttribute(value="useSsl") boolean useSsl, @PluginAttribute(value="verifyHostname") boolean verifyHostname, @PluginAttribute(value="sslAlgorithm") String sslAlgorithm, @PluginAttribute(value="sslPropertiesLocation") String sslPropertiesLocation, @PluginAttribute(value="keyStore") String keyStore, @PluginAttribute(value="keyStorePassphrase") String keyStorePassphrase, @PluginAttribute(value="keyStoreType") String keyStoreType, @PluginAttribute(value="trustStore") String trustStore, @PluginAttribute(value="trustStorePassphrase") String trustStorePassphrase, @PluginAttribute(value="trustStoreType") String trustStoreType, @PluginAttribute(value="saslConfig") String saslConfig, @PluginAttribute(value="senderPoolSize") int senderPoolSize, @PluginAttribute(value="maxSenderRetries") int maxSenderRetries, @PluginAttribute(value="applicationId") String applicationId, @PluginAttribute(value="routingKeyPattern") String routingKeyPattern, @PluginAttribute(value="generateId") boolean generateId, @PluginAttribute(value="deliveryMode") String deliveryMode, @PluginAttribute(value="exchange") String exchange, @PluginAttribute(value="exchangeType") String exchangeType, @PluginAttribute(value="declareExchange") boolean declareExchange, @PluginAttribute(value="durable") boolean durable, @PluginAttribute(value="autoDelete") boolean autoDelete, @PluginAttribute(value="contentType") String contentType, @PluginAttribute(value="contentEncoding") String contentEncoding, @PluginAttribute(value="connectionName") String connectionName, @PluginAttribute(value="clientConnectionProperties") String clientConnectionProperties, @PluginAttribute(value="async") boolean async, @PluginAttribute(value="charset") String charset, @PluginAttribute(value="bufferSize", defaultInt=0x7FFFFFFF) int bufferSize, @PluginElement(value="BlockingQueueFactory") BlockingQueueFactory<Event> blockingQueueFactory, @PluginAttribute(value="addMdcAsHeaders", defaultBoolean=true) boolean addMdcAsHeaders) {
        PatternLayout theLayout;
        if (name == null) {
            LOGGER.error("No name for AmqpAppender");
        }
        if ((theLayout = layout) == null) {
            theLayout = PatternLayout.createDefaultLayout();
        }
        AmqpManager manager = new AmqpManager(configuration.getLoggerContext(), name);
        JavaUtils.INSTANCE.acceptIfNotNull((Object)uri, value -> manager.uri = value).acceptIfNotNull((Object)host, value -> manager.host = value).acceptIfNotNull((Object)port, value -> manager.port = Integers.parseInt((String)value)).acceptIfNotNull((Object)addresses, value -> manager.addresses = value).acceptIfNotNull((Object)user, value -> manager.username = value).acceptIfNotNull((Object)password, value -> manager.password = value).acceptIfNotNull((Object)virtualHost, value -> manager.virtualHost = value).acceptIfNotNull((Object)useSsl, value -> manager.useSsl = value).acceptIfNotNull((Object)verifyHostname, value -> manager.verifyHostname = value).acceptIfNotNull((Object)sslAlgorithm, value -> manager.sslAlgorithm = value).acceptIfNotNull((Object)sslPropertiesLocation, value -> manager.sslPropertiesLocation = value).acceptIfNotNull((Object)keyStore, value -> manager.keyStore = value).acceptIfNotNull((Object)keyStorePassphrase, value -> manager.keyStorePassphrase = value).acceptIfNotNull((Object)keyStoreType, value -> manager.keyStoreType = value).acceptIfNotNull((Object)trustStore, value -> manager.trustStore = value).acceptIfNotNull((Object)trustStorePassphrase, value -> manager.trustStorePassphrase = value).acceptIfNotNull((Object)trustStoreType, value -> manager.trustStoreType = value).acceptIfNotNull((Object)saslConfig, value -> manager.saslConfig = value).acceptIfNotNull((Object)senderPoolSize, value -> manager.senderPoolSize = value).acceptIfNotNull((Object)maxSenderRetries, value -> manager.maxSenderRetries = value).acceptIfNotNull((Object)applicationId, value -> manager.applicationId = value).acceptIfNotNull((Object)routingKeyPattern, value -> manager.routingKeyPattern = value).acceptIfNotNull((Object)generateId, value -> manager.generateId = value).acceptIfNotNull((Object)deliveryMode, value -> manager.deliveryMode = MessageDeliveryMode.valueOf((String)deliveryMode)).acceptIfNotNull((Object)exchange, value -> manager.exchangeName = value).acceptIfNotNull((Object)exchangeType, value -> manager.exchangeType = value).acceptIfNotNull((Object)declareExchange, value -> manager.declareExchange = value).acceptIfNotNull((Object)durable, value -> manager.durable = value).acceptIfNotNull((Object)autoDelete, value -> manager.autoDelete = value).acceptIfNotNull((Object)contentType, value -> manager.contentType = value).acceptIfNotNull((Object)contentEncoding, value -> manager.contentEncoding = value).acceptIfNotNull((Object)connectionName, value -> manager.connectionName = value).acceptIfNotNull((Object)clientConnectionProperties, value -> manager.clientConnectionProperties = value).acceptIfNotNull((Object)charset, value -> manager.charset = value).acceptIfNotNull((Object)async, value -> manager.async = value).acceptIfNotNull((Object)addMdcAsHeaders, value -> manager.addMdcAsHeaders = value);
        LinkedBlockingQueue<Event> eventQueue = blockingQueueFactory == null ? new LinkedBlockingQueue<Event>(bufferSize) : blockingQueueFactory.create(bufferSize);
        AmqpAppender appender = new AmqpAppender(name, filter, (Layout<? extends Serializable>)theLayout, ignoreExceptions, manager, eventQueue);
        if (manager.activateOptions()) {
            appender.startSenders();
            return appender;
        }
        return null;
    }

    private void startSenders() {
        this.rabbitTemplate.setConnectionFactory(this.manager.connectionFactory);
        if (this.manager.async) {
            for (int i = 0; i < this.manager.senderPoolSize; ++i) {
                this.manager.senderPool.submit(new EventSender());
            }
        } else if (this.manager.maxSenderRetries > 0) {
            RetryTemplate retryTemplate = new RetryTemplate();
            SimpleRetryPolicy retryPolicy = new SimpleRetryPolicy(this.manager.maxSenderRetries);
            retryTemplate.setRetryPolicy((RetryPolicy)retryPolicy);
            this.rabbitTemplate.setRetryTemplate(retryTemplate);
        }
    }

    public void append(LogEvent event) {
        Event appenderEvent = new Event(event, event.getContextData().toMap());
        if (this.manager.async) {
            this.events.add(appenderEvent);
        } else {
            this.sendEvent(appenderEvent, appenderEvent.getProperties());
        }
    }

    protected Message postProcessMessageBeforeSend(Message message, Event event) {
        return message;
    }

    protected void sendEvent(Event event, Map<?, ?> properties) {
        LogEvent logEvent = event.getEvent();
        String name = logEvent.getLoggerName();
        Level level = logEvent.getLevel();
        MessageProperties amqpProps = new MessageProperties();
        JavaUtils.INSTANCE.acceptIfNotNull((Object)this.manager.deliveryMode, arg_0 -> ((MessageProperties)amqpProps).setDeliveryMode(arg_0)).acceptIfNotNull((Object)this.manager.contentType, arg_0 -> ((MessageProperties)amqpProps).setContentType(arg_0)).acceptIfNotNull((Object)this.manager.contentEncoding, arg_0 -> ((MessageProperties)amqpProps).setContentEncoding(arg_0));
        amqpProps.setHeader(CATEGORY_NAME, (Object)name);
        amqpProps.setHeader(THREAD_NAME, (Object)logEvent.getThreadName());
        amqpProps.setHeader(CATEGORY_LEVEL, (Object)level.toString());
        if (this.manager.generateId) {
            amqpProps.setMessageId(UUID.randomUUID().toString());
        }
        if (null != this.manager.applicationId) {
            amqpProps.setAppId(this.manager.applicationId);
        }
        Calendar tstamp = Calendar.getInstance();
        tstamp.setTimeInMillis(logEvent.getTimeMillis());
        amqpProps.setTimestamp(tstamp.getTime());
        if (this.manager.addMdcAsHeaders) {
            for (Map.Entry<?, ?> entry : properties.entrySet()) {
                amqpProps.setHeader(entry.getKey().toString(), entry.getValue());
            }
        }
        if (logEvent.getSource() != null) {
            amqpProps.setHeader("location", (Object)String.format("%s.%s()[%s]", logEvent.getSource().getClassName(), logEvent.getSource().getMethodName(), logEvent.getSource().getLineNumber()));
        }
        this.doSend(event, logEvent, amqpProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(final Event event, LogEvent logEvent, MessageProperties amqpProps) {
        try {
            String routingKey;
            StringBuilder msgBody;
            Object object = this.layoutMutex;
            synchronized (object) {
                msgBody = new StringBuilder(new String(this.getLayout().toByteArray(logEvent), StandardCharsets.UTF_8));
                routingKey = new String(this.manager.routingKeyLayout.toByteArray(logEvent), StandardCharsets.UTF_8);
            }
            Message message = null;
            if (this.manager.charset != null) {
                try {
                    message = new Message(msgBody.toString().getBytes(this.manager.charset), amqpProps);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            if (message == null) {
                message = new Message(msgBody.toString().getBytes(), amqpProps);
            }
            message = this.postProcessMessageBeforeSend(message, event);
            this.rabbitTemplate.send(this.manager.exchangeName, routingKey, message);
        }
        catch (AmqpException e) {
            int retries = event.incrementRetries();
            if (this.manager.async && retries < this.manager.maxSenderRetries) {
                this.manager.retryTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        AmqpAppender.this.events.add(event);
                    }
                }, (long)(Math.pow(retries, Math.log(retries)) * 1000.0));
            } else {
                this.getHandler().error("Could not send log message " + logEvent.getMessage() + " after " + this.manager.maxSenderRetries + " retries", logEvent, (Throwable)e);
            }
        }
        catch (Exception e) {
            this.getHandler().error("Could not send log message " + logEvent.getMessage(), logEvent, (Throwable)e);
        }
    }

    protected boolean stop(long timeout, TimeUnit timeUnit, boolean changeLifeCycleState) {
        boolean stopped = super.stop(timeout, timeUnit, changeLifeCycleState);
        return stopped || this.manager.stop(timeout, timeUnit);
    }

    public int getQueuedEventCount() {
        return this.events.size();
    }

    protected static class AmqpManager
    extends AbstractManager {
        private static final int DEFAULT_MAX_SENDER_RETRIES = 30;
        private boolean async;
        private String exchangeName = "logs";
        private String exchangeType = "topic";
        private String routingKeyPattern = "%c.%p";
        private Layout<String> routingKeyLayout;
        private String applicationId = null;
        private int senderPoolSize = 2;
        private int maxSenderRetries = 30;
        private AbstractConnectionFactory connectionFactory;
        private URI uri;
        private String host;
        private String addresses;
        private String virtualHost;
        private Integer port;
        private String username;
        private String password;
        private boolean useSsl;
        private boolean verifyHostname = true;
        private String sslAlgorithm;
        private String sslPropertiesLocation;
        private String keyStore;
        private String keyStorePassphrase;
        private String keyStoreType = "JKS";
        private String trustStore;
        private String trustStorePassphrase;
        private String trustStoreType = "JKS";
        private String saslConfig;
        private String contentType = "text/plain";
        private String contentEncoding = null;
        private boolean declareExchange = false;
        private String connectionName;
        private String clientConnectionProperties;
        private String charset = Charset.defaultCharset().name();
        private boolean addMdcAsHeaders = true;
        private boolean durable = true;
        private MessageDeliveryMode deliveryMode = MessageDeliveryMode.PERSISTENT;
        private boolean autoDelete = false;
        private boolean generateId = false;
        private ExecutorService senderPool = null;
        private final Timer retryTimer = new Timer("log-event-retry-delay", true);

        protected AmqpManager(LoggerContext loggerContext, String name) {
            super(loggerContext, name);
        }

        private boolean activateOptions() {
            ConnectionFactory rabbitConnectionFactory = this.createRabbitConnectionFactory();
            if (rabbitConnectionFactory != null) {
                Assert.state((this.applicationId != null ? 1 : 0) != 0, (String)"applicationId is required");
                this.routingKeyLayout = PatternLayout.newBuilder().withPattern(this.routingKeyPattern.replaceAll("%X\\{applicationId}", this.applicationId)).withCharset(Charset.forName(this.charset)).withAlwaysWriteExceptions(false).withNoConsoleNoAnsi(true).build();
                this.connectionFactory = new CachingConnectionFactory(rabbitConnectionFactory);
                if (StringUtils.hasText((String)this.connectionName)) {
                    this.connectionFactory.setConnectionNameStrategy(cf -> this.connectionName);
                }
                if (this.addresses != null) {
                    this.connectionFactory.setAddresses(this.addresses);
                }
                if (this.clientConnectionProperties != null) {
                    ConnectionFactoryConfigurationUtils.updateClientConnectionProperties(this.connectionFactory, this.clientConnectionProperties);
                }
                this.setUpExchangeDeclaration();
                this.senderPool = Executors.newCachedThreadPool();
                return true;
            }
            return false;
        }

        protected ConnectionFactory createRabbitConnectionFactory() {
            RabbitConnectionFactoryBean factoryBean = new RabbitConnectionFactoryBean();
            this.configureRabbitConnectionFactory(factoryBean);
            try {
                factoryBean.afterPropertiesSet();
                return (ConnectionFactory)factoryBean.getObject();
            }
            catch (Exception e) {
                LOGGER.error("Failed to create customized Rabbit ConnectionFactory.", (Throwable)e);
                return null;
            }
        }

        protected void configureRabbitConnectionFactory(RabbitConnectionFactoryBean factoryBean) {
            JavaUtils.INSTANCE.acceptIfNotNull((Object)this.host, factoryBean::setHost).acceptIfNotNull((Object)this.port, factoryBean::setPort).acceptIfNotNull((Object)this.username, factoryBean::setUsername).acceptIfNotNull((Object)this.password, factoryBean::setPassword).acceptIfNotNull((Object)this.virtualHost, factoryBean::setVirtualHost).acceptIfNotNull((Object)this.uri, factoryBean::setUri);
            if (this.useSsl) {
                factoryBean.setUseSSL(true);
                factoryBean.setEnableHostnameVerification(this.verifyHostname);
                if (this.sslAlgorithm != null) {
                    factoryBean.setSslAlgorithm(this.sslAlgorithm);
                }
                if (this.sslPropertiesLocation != null) {
                    PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                    Resource sslPropertiesResource = resolver.getResource(this.sslPropertiesLocation);
                    factoryBean.setSslPropertiesLocation(sslPropertiesResource);
                } else {
                    factoryBean.setKeyStore(this.keyStore);
                    factoryBean.setKeyStorePassphrase(this.keyStorePassphrase);
                    factoryBean.setKeyStoreType(this.keyStoreType);
                    factoryBean.setTrustStore(this.trustStore);
                    factoryBean.setTrustStorePassphrase(this.trustStorePassphrase);
                    factoryBean.setTrustStoreType(this.trustStoreType);
                    JavaUtils.INSTANCE.acceptIfNotNull((Object)this.saslConfig, config -> {
                        try {
                            factoryBean.setSaslConfig(RabbitUtils.stringToSaslConfig(config, factoryBean.getRabbitConnectionFactory()));
                        }
                        catch (Exception e) {
                            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
                        }
                    });
                }
            }
        }

        protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
            this.retryTimer.cancel();
            this.senderPool.shutdownNow();
            this.connectionFactory.destroy();
            try {
                return this.senderPool.awaitTermination(timeout, timeUnit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }

        protected void setUpExchangeDeclaration() {
            RabbitAdmin admin = new RabbitAdmin(this.connectionFactory);
            if (this.declareExchange) {
                Object x = "topic".equals(this.exchangeType) ? new TopicExchange(this.exchangeName, this.durable, this.autoDelete) : ("direct".equals(this.exchangeType) ? new DirectExchange(this.exchangeName, this.durable, this.autoDelete) : ("fanout".equals(this.exchangeType) ? new FanoutExchange(this.exchangeName, this.durable, this.autoDelete) : ("headers".equals(this.exchangeType) ? new HeadersExchange(this.exchangeName, this.durable, this.autoDelete) : new TopicExchange(this.exchangeName, this.durable, this.autoDelete))));
                this.connectionFactory.addConnectionListener(new DeclareExchangeConnectionListener((Exchange)x, admin));
            }
        }
    }

    protected static class Event {
        private final LogEvent event;
        private final Map<?, ?> properties;
        private final AtomicInteger retries = new AtomicInteger(0);

        public Event(LogEvent event, Map<?, ?> properties) {
            this.event = event;
            this.properties = properties;
        }

        public LogEvent getEvent() {
            return this.event;
        }

        public Map<?, ?> getProperties() {
            return this.properties;
        }

        public int incrementRetries() {
            return this.retries.incrementAndGet();
        }
    }

    protected class EventSender
    implements Runnable {
        protected EventSender() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Event event = (Event)AmqpAppender.this.events.take();
                    AmqpAppender.this.sendEvent(event, event.getProperties());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }
}

