/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.amqp.rabbit.listener.AbstractRabbitListenerEndpoint;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.adapter.BatchMessagingMessageListenerAdapter;
import org.springframework.amqp.rabbit.listener.adapter.HandlerAdapter;
import org.springframework.amqp.rabbit.listener.adapter.MessagingMessageListenerAdapter;
import org.springframework.amqp.rabbit.listener.api.RabbitListenerErrorHandler;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;

public class MethodRabbitListenerEndpoint
extends AbstractRabbitListenerEndpoint {
    private Object bean;
    private Method method;
    private MessageHandlerMethodFactory messageHandlerMethodFactory;
    private boolean returnExceptions;
    private RabbitListenerErrorHandler errorHandler;

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
        this.messageHandlerMethodFactory = messageHandlerMethodFactory;
    }

    public void setReturnExceptions(boolean returnExceptions) {
        this.returnExceptions = returnExceptions;
    }

    public void setErrorHandler(RabbitListenerErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
        return this.messageHandlerMethodFactory;
    }

    @Override
    protected MessagingMessageListenerAdapter createMessageListener(MessageListenerContainer container) {
        MessageConverter messageConverter;
        Assert.state((this.messageHandlerMethodFactory != null ? 1 : 0) != 0, (String)"Could not create message listener - MessageHandlerMethodFactory not set");
        MessagingMessageListenerAdapter messageListener = this.createMessageListenerInstance();
        messageListener.setHandlerAdapter(this.configureListenerAdapter(messageListener));
        String replyToAddress = this.getDefaultReplyToAddress();
        if (replyToAddress != null) {
            messageListener.setResponseAddress(replyToAddress);
        }
        if ((messageConverter = this.getMessageConverter()) != null) {
            messageListener.setMessageConverter(messageConverter);
        }
        if (this.getBeanResolver() != null) {
            messageListener.setBeanResolver(this.getBeanResolver());
        }
        return messageListener;
    }

    protected HandlerAdapter configureListenerAdapter(MessagingMessageListenerAdapter messageListener) {
        InvocableHandlerMethod invocableHandlerMethod = this.messageHandlerMethodFactory.createInvocableHandlerMethod(this.getBean(), this.getMethod());
        return new HandlerAdapter(invocableHandlerMethod);
    }

    protected MessagingMessageListenerAdapter createMessageListenerInstance() {
        if (this.isBatchListener()) {
            return new BatchMessagingMessageListenerAdapter(this.bean, this.method, this.returnExceptions, this.errorHandler, this.getBatchingStrategy());
        }
        return new MessagingMessageListenerAdapter(this.bean, this.method, this.returnExceptions, this.errorHandler);
    }

    @Nullable
    private String getDefaultReplyToAddress() {
        SendTo ann;
        Method listenerMethod = this.getMethod();
        if (listenerMethod != null && (ann = (SendTo)AnnotationUtils.getAnnotation((Method)listenerMethod, SendTo.class)) != null) {
            Object[] destinations = ann.value();
            if (destinations.length > 1) {
                throw new IllegalStateException("Invalid @" + SendTo.class.getSimpleName() + " annotation on '" + listenerMethod + "' one destination must be set (got " + Arrays.toString(destinations) + ")");
            }
            return destinations.length == 1 ? this.resolveSendTo(destinations[0]) : "";
        }
        return null;
    }

    private String resolveSendTo(String value) {
        if (this.getBeanFactory() != null) {
            String resolvedValue = this.getBeanExpressionContext().getBeanFactory().resolveEmbeddedValue(value);
            Object newValue = this.getResolver().evaluate(resolvedValue, this.getBeanExpressionContext());
            Assert.isInstanceOf(String.class, (Object)newValue, (String)"Invalid @SendTo expression");
            return (String)newValue;
        }
        return value;
    }

    @Override
    protected StringBuilder getEndpointDescription() {
        return super.getEndpointDescription().append(" | bean='").append(this.bean).append("'").append(" | method='").append(this.method).append("'");
    }
}

