/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.springframework.amqp.rabbit.connection.LocalizedQueueConnectionFactory;
import org.springframework.amqp.rabbit.connection.RestTemplateHolder;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriUtils;

public class RestTemplateNodeLocator
implements LocalizedQueueConnectionFactory.NodeLocator<RestTemplateHolder> {
    @Override
    public RestTemplateHolder createClient(String userName, String password) {
        return new RestTemplateHolder(userName, password);
    }

    @Override
    @Nullable
    public Map<String, Object> restCall(RestTemplateHolder client, String baseUri, String vhost, String queue) throws URISyntaxException {
        ResponseEntity response;
        URI uri;
        if (client.template == null) {
            uri = new URI(baseUri);
            final HttpHost host = new HttpHost(uri.getHost(), uri.getPort());
            client.template = new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory(){

                @Nullable
                protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
                    BasicAuthCache cache = new BasicAuthCache();
                    BasicScheme scheme = new BasicScheme();
                    cache.put(host, (AuthScheme)scheme);
                    BasicHttpContext context = new BasicHttpContext();
                    context.setAttribute("http.auth.auth-cache", (Object)cache);
                    return context;
                }
            });
            client.template.getInterceptors().add(new BasicAuthenticationInterceptor(client.userName, client.password));
        }
        return (response = client.template.exchange(uri = new URI(baseUri).resolve("/api/queues/" + UriUtils.encodePathSegment((String)vhost, (Charset)StandardCharsets.UTF_8) + "/" + queue), HttpMethod.GET, null, Map.class)).getStatusCode().equals((Object)HttpStatus.OK) ? (Map)response.getBody() : null;
    }
}

