/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.ShutdownListener;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.AbstractConnectionFactory;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.connection.SimpleConnection;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;
import org.springframework.context.SmartLifecycle;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ThreadChannelConnectionFactory
extends AbstractConnectionFactory
implements ShutdownListener,
SmartLifecycle {
    private final Map<UUID, Context> contextSwitches = new ConcurrentHashMap<UUID, Context>();
    private final Map<UUID, Thread> switchesInProgress = new ConcurrentHashMap<UUID, Thread>();
    private final AtomicBoolean running = new AtomicBoolean();
    private volatile ConnectionWrapper connection;
    private boolean simplePublisherConfirms;
    private boolean defaultPublisherFactory = true;

    public ThreadChannelConnectionFactory(com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory) {
        this(rabbitConnectionFactory, false);
    }

    private ThreadChannelConnectionFactory(com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory, boolean isPublisher) {
        super(rabbitConnectionFactory);
        if (!isPublisher) {
            this.setPublisherConnectionFactory(new ThreadChannelConnectionFactory(rabbitConnectionFactory, true));
        } else {
            this.defaultPublisherFactory = false;
        }
    }

    @Override
    public void setPublisherConnectionFactory(@Nullable AbstractConnectionFactory publisherConnectionFactory) {
        super.setPublisherConnectionFactory(publisherConnectionFactory);
        this.defaultPublisherFactory = false;
    }

    @Override
    public boolean isSimplePublisherConfirms() {
        return this.simplePublisherConfirms;
    }

    public void setSimplePublisherConfirms(boolean simplePublisherConfirms) {
        this.simplePublisherConfirms = simplePublisherConfirms;
        if (this.defaultPublisherFactory) {
            ((ThreadChannelConnectionFactory)this.getPublisherConnectionFactory()).setSimplePublisherConfirms(simplePublisherConfirms);
        }
    }

    public int getPhase() {
        return Integer.MIN_VALUE;
    }

    public void start() {
        this.running.set(true);
    }

    public void stop() {
        this.running.set(false);
        this.resetConnection();
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        super.addConnectionListener(listener);
        if (this.connection != null && this.connection.isOpen()) {
            listener.onCreate(this.connection);
        }
    }

    @Override
    public synchronized Connection createConnection() throws AmqpException {
        if (this.connection == null || !this.connection.isOpen()) {
            Connection bareConnection = this.createBareConnection();
            this.connection = new ConnectionWrapper(bareConnection.getDelegate(), this.getCloseTimeout());
            this.getConnectionListener().onCreate(this.connection);
        }
        return this.connection;
    }

    public void closeThreadChannel() {
        ConnectionWrapper connection2 = this.connection;
        if (connection2 != null) {
            connection2.closeThreadChannel();
        }
    }

    @Override
    public void resetConnection() {
        this.destroy();
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        if (this.connection != null) {
            this.connection.forceClose();
            this.connection = null;
        }
        if (this.switchesInProgress.size() > 0 && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)("Unclaimed context switches from threads:" + this.switchesInProgress.values().stream().map(t -> t.getName()).collect(Collectors.toList())));
        }
        this.contextSwitches.clear();
        this.switchesInProgress.clear();
    }

    @Nullable
    public Object prepareSwitchContext() {
        return this.prepareSwitchContext(UUID.randomUUID());
    }

    @Nullable
    Object prepareSwitchContext(UUID uuid) {
        Context context;
        Object pubContext = null;
        ConnectionFactory connectionFactory = this.getPublisherConnectionFactory();
        if (connectionFactory instanceof ThreadChannelConnectionFactory) {
            ThreadChannelConnectionFactory tccf = (ThreadChannelConnectionFactory)connectionFactory;
            pubContext = tccf.prepareSwitchContext(uuid);
        }
        if ((context = ((ConnectionWrapper)this.createConnection()).prepareSwitchContext()).getNonTx() == null && context.getTx() == null) {
            this.logger.debug((Object)"No channels are bound to this thread");
            return pubContext;
        }
        if (this.switchesInProgress.values().contains(Thread.currentThread())) {
            this.logger.warn((Object)"A previous context switch from this thread has not been claimed yet; possible memory leak?");
        }
        this.contextSwitches.put(uuid, context);
        this.switchesInProgress.put(uuid, Thread.currentThread());
        return uuid;
    }

    public void switchContext(@Nullable Object toSwitch) {
        if (toSwitch != null) {
            Assert.state((boolean)this.doSwitch(toSwitch), () -> "No context to switch for " + toSwitch.toString());
        } else {
            this.logger.debug((Object)"Attempted to switch a null context - no channels to acquire");
        }
    }

    boolean doSwitch(Object toSwitch) {
        boolean switched = false;
        ConnectionFactory connectionFactory = this.getPublisherConnectionFactory();
        if (connectionFactory instanceof ThreadChannelConnectionFactory) {
            ThreadChannelConnectionFactory tccf = (ThreadChannelConnectionFactory)connectionFactory;
            switched = tccf.doSwitch(toSwitch);
        }
        Context context = this.contextSwitches.remove(toSwitch);
        this.switchesInProgress.remove(toSwitch);
        if (context != null) {
            ((ConnectionWrapper)this.createConnection()).switchContext(context);
            switched = true;
        }
        return switched;
    }

    private final class ConnectionWrapper
    extends SimpleConnection {
        private final ThreadLocal<Channel> channels;
        private final ThreadLocal<Channel> txChannels;

        ConnectionWrapper(com.rabbitmq.client.Connection delegate, int closeTimeout) {
            super(delegate, closeTimeout);
            this.channels = new ThreadLocal();
            this.txChannels = new ThreadLocal();
        }

        @Override
        public Channel createChannel(boolean transactional) {
            Channel channel;
            Channel channel2 = channel = transactional ? this.txChannels.get() : this.channels.get();
            if (channel == null || !channel.isOpen()) {
                channel = this.createProxy(super.createChannel(transactional), transactional);
                if (transactional) {
                    try {
                        channel.txSelect();
                    }
                    catch (IOException e) {
                        throw RabbitExceptionTranslator.convertRabbitAccessException(e);
                    }
                    this.txChannels.set(channel);
                } else {
                    if (ThreadChannelConnectionFactory.this.simplePublisherConfirms) {
                        try {
                            channel.confirmSelect();
                        }
                        catch (IOException e) {
                            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
                        }
                    }
                    this.channels.set(channel);
                }
                ThreadChannelConnectionFactory.this.getChannelListener().onCreate(channel, transactional);
            }
            return channel;
        }

        private Channel createProxy(Channel channel, boolean transactional) {
            ProxyFactory pf = new ProxyFactory((Object)channel);
            AtomicBoolean confirmSelected = new AtomicBoolean();
            MethodInterceptor advice = invocation -> {
                String method;
                switch (method = invocation.getMethod().getName()) {
                    case "close": {
                        this.handleClose(channel, transactional);
                        return null;
                    }
                    case "getTargetChannel": {
                        return channel;
                    }
                    case "isTransactional": {
                        return transactional;
                    }
                    case "confirmSelect": {
                        confirmSelected.set(true);
                        return channel.confirmSelect();
                    }
                    case "isConfirmSelected": {
                        return confirmSelected.get();
                    }
                    case "isPublisherConfirms": {
                        return false;
                    }
                }
                return null;
            };
            NameMatchMethodPointcutAdvisor advisor = new NameMatchMethodPointcutAdvisor((Advice)advice);
            advisor.addMethodName("close");
            advisor.addMethodName("getTargetChannel");
            advisor.addMethodName("isTransactional");
            advisor.addMethodName("confirmSelect");
            advisor.addMethodName("isConfirmSelected");
            advisor.addMethodName("isPublisherConfirms");
            pf.addAdvisor((Advisor)advisor);
            pf.addInterface(ChannelProxy.class);
            return (Channel)pf.getProxy();
        }

        private void handleClose(Channel channel, boolean transactional) {
            if (transactional && this.txChannels.get() == null || !transactional && this.channels.get() == null) {
                this.physicalClose(channel);
            } else if (RabbitUtils.isPhysicalCloseRequired()) {
                this.physicalClose(channel);
                if (transactional) {
                    this.txChannels.remove();
                } else {
                    this.channels.remove();
                }
            }
        }

        @Override
        public void close() {
        }

        @Override
        public void closeThreadChannel() {
            this.doClose(this.channels);
            this.doClose(this.txChannels);
        }

        private void doClose(ThreadLocal<Channel> channelsTL) {
            Channel channel = channelsTL.get();
            if (channel != null) {
                channelsTL.remove();
                this.physicalClose(channel);
            }
        }

        private void physicalClose(Channel channel) {
            if (channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException | TimeoutException e) {
                    ThreadChannelConnectionFactory.this.logger.debug((Object)"Error on close", (Throwable)e);
                }
                finally {
                    RabbitUtils.clearPhysicalCloseRequired();
                }
            }
        }

        void forceClose() {
            super.close();
            ThreadChannelConnectionFactory.this.getConnectionListener().onClose(this);
        }

        Context prepareSwitchContext() {
            Context context = new Context(this.channels.get(), this.txChannels.get());
            this.channels.remove();
            this.txChannels.remove();
            return context;
        }

        void switchContext(Context context) {
            Channel tx;
            Channel nonTx = context.getNonTx();
            if (nonTx != null) {
                this.doSwitch(nonTx, this.channels);
            }
            if ((tx = context.getTx()) != null) {
                this.doSwitch(tx, this.txChannels);
            }
        }

        private void doSwitch(Channel channel, ThreadLocal<Channel> channelTL) {
            Channel toClose = channelTL.get();
            if (toClose != null) {
                RabbitUtils.setPhysicalCloseRequired(channel, true);
                this.physicalClose(toClose);
            }
            channelTL.set(channel);
        }
    }

    private static class Context {
        private final Channel nonTx;
        private final Channel tx;

        Context(@Nullable Channel nonTx, @Nullable Channel tx) {
            this.nonTx = nonTx;
            this.tx = tx;
        }

        @Nullable
        Channel getNonTx() {
            return this.nonTx;
        }

        @Nullable
        Channel getTx() {
            return this.tx;
        }
    }
}

