/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.ImmediateAcknowledgeAmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.listener.FatalExceptionStrategy;
import org.springframework.amqp.rabbit.support.ListenerExecutionFailedException;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.handler.invocation.MethodArgumentResolutionException;
import org.springframework.util.ErrorHandler;

public class ConditionalRejectingErrorHandler
implements ErrorHandler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final FatalExceptionStrategy exceptionStrategy;
    private boolean discardFatalsWithXDeath = true;
    private boolean rejectManual = true;

    public ConditionalRejectingErrorHandler() {
        this.exceptionStrategy = new DefaultExceptionStrategy();
    }

    public ConditionalRejectingErrorHandler(FatalExceptionStrategy exceptionStrategy) {
        this.exceptionStrategy = exceptionStrategy;
    }

    protected boolean isDiscardFatalsWithXDeath() {
        return this.discardFatalsWithXDeath;
    }

    public void setDiscardFatalsWithXDeath(boolean discardFatalsWithXDeath) {
        this.discardFatalsWithXDeath = discardFatalsWithXDeath;
    }

    protected boolean isRejectManual() {
        return this.rejectManual;
    }

    public void setRejectManual(boolean rejectManual) {
        this.rejectManual = rejectManual;
    }

    protected FatalExceptionStrategy getExceptionStrategy() {
        return this.exceptionStrategy;
    }

    public void handleError(Throwable t) {
        this.log(t);
        if (!this.causeChainContainsARADRE(t) && this.exceptionStrategy.isFatal(t)) {
            List xDeath;
            ListenerExecutionFailedException lefe;
            Message failed;
            if (this.discardFatalsWithXDeath && t instanceof ListenerExecutionFailedException && (failed = (lefe = (ListenerExecutionFailedException)((Object)t)).getFailedMessage()) != null && (xDeath = failed.getMessageProperties().getXDeathHeader()) != null && xDeath.size() > 0) {
                this.logger.error((Object)("x-death header detected on a message with a fatal exception; perhaps requeued from a DLQ? - discarding: " + failed));
                this.handleDiscarded(failed);
                throw new ImmediateAcknowledgeAmqpException("Fatal and x-death present");
            }
            throw new AmqpRejectAndDontRequeueException("Error Handler converted exception to fatal", this.rejectManual, t);
        }
    }

    protected void handleDiscarded(Message failed) {
    }

    protected void log(Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"Execution of Rabbit message listener failed.", t);
        }
    }

    protected boolean causeChainContainsARADRE(Throwable t) {
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof AmqpRejectAndDontRequeueException)) continue;
            return true;
        }
        return false;
    }

    public static class DefaultExceptionStrategy
    implements FatalExceptionStrategy {
        protected final Log logger = LogFactory.getLog(this.getClass());

        @Override
        public boolean isFatal(Throwable t) {
            Throwable cause = t.getCause();
            while (cause instanceof MessagingException && !(cause instanceof MessageConversionException) && !(cause instanceof MethodArgumentResolutionException)) {
                cause = cause.getCause();
            }
            if (t instanceof ListenerExecutionFailedException) {
                ListenerExecutionFailedException lefe = (ListenerExecutionFailedException)((Object)t);
                if (this.isCauseFatal(cause)) {
                    this.logFatalException(lefe, cause);
                    return true;
                }
            }
            return false;
        }

        private boolean isCauseFatal(Throwable cause) {
            return cause instanceof org.springframework.amqp.support.converter.MessageConversionException || cause instanceof MessageConversionException || cause instanceof MethodArgumentResolutionException || cause instanceof NoSuchMethodException || cause instanceof ClassCastException || this.isUserCauseFatal(cause);
        }

        protected void logFatalException(ListenerExecutionFailedException t, Throwable cause) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Fatal message conversion error; message rejected; it will be dropped or routed to a dead letter exchange, if so configured: " + t.getFailedMessage()));
            }
        }

        protected boolean isUserCauseFatal(Throwable cause) {
            return false;
        }
    }
}

