/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.AmqpAdmin;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.Declarable;
import org.springframework.amqp.core.DeclarableCustomizer;
import org.springframework.amqp.core.Declarables;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueInformation;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.DeclarationExceptionEvent;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.lang.Nullable;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ManagedResource(description="Admin Tasks")
public class RabbitAdmin
implements AmqpAdmin,
ApplicationContextAware,
ApplicationEventPublisherAware,
BeanNameAware,
InitializingBean {
    private static final String UNUSED = "unused";
    private static final int DECLARE_MAX_ATTEMPTS = 5;
    private static final int DECLARE_INITIAL_RETRY_INTERVAL = 1000;
    private static final int DECLARE_MAX_RETRY_INTERVAL = 5000;
    private static final double DECLARE_RETRY_MULTIPLIER = 2.0;
    public static final String DEFAULT_EXCHANGE_NAME = "";
    public static final Object QUEUE_NAME = "QUEUE_NAME";
    public static final Object QUEUE_MESSAGE_COUNT = "QUEUE_MESSAGE_COUNT";
    public static final Object QUEUE_CONSUMER_COUNT = "QUEUE_CONSUMER_COUNT";
    private static final String DELAYED_MESSAGE_EXCHANGE = "x-delayed-message";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Lock lock = new ReentrantLock();
    private final RabbitTemplate rabbitTemplate;
    private final Lock lifecycleLock = new ReentrantLock();
    private final ConnectionFactory connectionFactory;
    private final Set<Declarable> manualDeclarables = Collections.synchronizedSet(new LinkedHashSet());
    private final Lock manualDeclarablesLock = new ReentrantLock();
    private String beanName;
    private RetryTemplate retryTemplate;
    private boolean retryDisabled;
    private boolean autoStartup = true;
    private ApplicationContext applicationContext;
    private boolean ignoreDeclarationExceptions;
    private ApplicationEventPublisher applicationEventPublisher;
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
    private boolean explicitDeclarationsOnly;
    private boolean redeclareManualDeclarations;
    private volatile boolean running = false;
    private volatile DeclarationExceptionEvent lastDeclarationExceptionEvent;

    public RabbitAdmin(ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        this.connectionFactory = connectionFactory;
        this.rabbitTemplate = new RabbitTemplate(connectionFactory);
    }

    public RabbitAdmin(RabbitTemplate rabbitTemplate) {
        Assert.notNull((Object)rabbitTemplate, (String)"RabbitTemplate must not be null");
        Assert.notNull((Object)rabbitTemplate.getConnectionFactory(), (String)"RabbitTemplate's ConnectionFactory must not be null");
        this.connectionFactory = rabbitTemplate.getConnectionFactory();
        this.rabbitTemplate = rabbitTemplate;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setIgnoreDeclarationExceptions(boolean ignoreDeclarationExceptions) {
        this.ignoreDeclarationExceptions = ignoreDeclarationExceptions;
    }

    public DeclarationExceptionEvent getLastDeclarationExceptionEvent() {
        return this.lastDeclarationExceptionEvent;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"'taskExecutor' cannot be null");
        this.taskExecutor = taskExecutor;
    }

    public RabbitTemplate getRabbitTemplate() {
        return this.rabbitTemplate;
    }

    public void declareExchange(Exchange exchange) {
        try {
            this.rabbitTemplate.execute(channel -> {
                this.declareExchanges(channel, exchange);
                if (this.redeclareManualDeclarations) {
                    this.manualDeclarables.add((Declarable)exchange);
                }
                return null;
            });
        }
        catch (AmqpException e) {
            this.logOrRethrowDeclarationException((Declarable)exchange, "exchange", e);
        }
    }

    @ManagedOperation(description="Delete an exchange from the broker")
    public boolean deleteExchange(String exchangeName) {
        return this.rabbitTemplate.execute(channel -> {
            if (this.isDeletingDefaultExchange(exchangeName)) {
                return true;
            }
            try {
                channel.exchangeDelete(exchangeName);
                this.removeExchangeBindings(exchangeName);
            }
            catch (IOException e) {
                return false;
            }
            return true;
        });
    }

    private void removeExchangeBindings(String exchangeName) {
        this.manualDeclarablesLock.lock();
        try {
            this.manualDeclarables.stream().filter(dec -> {
                Exchange ex;
                return dec instanceof Exchange && (ex = (Exchange)dec).getName().equals(exchangeName);
            }).collect(Collectors.toSet()).forEach(this.manualDeclarables::remove);
            this.manualDeclarables.removeIf(next -> {
                Binding binding;
                return next instanceof Binding && (!(binding = (Binding)next).isDestinationQueue() && binding.getDestination().equals(exchangeName) || binding.getExchange().equals(exchangeName));
            });
        }
        finally {
            this.manualDeclarablesLock.unlock();
        }
    }

    @ManagedOperation(description="Declare a queue on the broker (this operation is not available remotely)")
    @Nullable
    public String declareQueue(Queue queue) {
        try {
            return this.rabbitTemplate.execute(channel -> {
                String result;
                AMQP.Queue.DeclareOk[] declared = this.declareQueues(channel, queue);
                String string = result = declared.length > 0 ? declared[0].getQueue() : null;
                if (this.redeclareManualDeclarations) {
                    this.manualDeclarables.add((Declarable)queue);
                }
                return result;
            });
        }
        catch (AmqpException e) {
            this.logOrRethrowDeclarationException((Declarable)queue, "queue", e);
            return null;
        }
    }

    @ManagedOperation(description="Declare a queue with a broker-generated name (this operation is not available remotely)")
    @Nullable
    public Queue declareQueue() {
        try {
            AMQP.Queue.DeclareOk declareOk = this.rabbitTemplate.execute(Channel::queueDeclare);
            return new Queue(declareOk.getQueue(), false, true, true);
        }
        catch (AmqpException e) {
            this.logOrRethrowDeclarationException(null, "queue", e);
            return null;
        }
    }

    @ManagedOperation(description="Delete a queue from the broker")
    public boolean deleteQueue(String queueName) {
        return this.rabbitTemplate.execute(channel -> {
            try {
                channel.queueDelete(queueName);
                this.removeQueueBindings(queueName);
            }
            catch (IOException e) {
                return false;
            }
            return true;
        });
    }

    @ManagedOperation(description="Delete a queue from the broker if unused and empty (when corresponding arguments are true")
    public void deleteQueue(String queueName, boolean unused, boolean empty) {
        this.rabbitTemplate.execute(channel -> {
            channel.queueDelete(queueName, unused, empty);
            this.removeQueueBindings(queueName);
            return null;
        });
    }

    private void removeQueueBindings(String queueName) {
        this.manualDeclarablesLock.lock();
        try {
            this.manualDeclarables.stream().filter(dec -> {
                Queue queue;
                return dec instanceof Queue && (queue = (Queue)dec).getName().equals(queueName);
            }).collect(Collectors.toSet()).forEach(this.manualDeclarables::remove);
            this.manualDeclarables.removeIf(next -> {
                Binding binding;
                return next instanceof Binding && (binding = (Binding)next).isDestinationQueue() && binding.getDestination().equals(queueName);
            });
        }
        finally {
            this.manualDeclarablesLock.unlock();
        }
    }

    @ManagedOperation(description="Purge a queue and optionally don't wait for the purge to occur")
    public void purgeQueue(String queueName, boolean noWait) {
        if (noWait) {
            this.taskExecutor.execute(() -> this.purgeQueue(queueName));
        } else {
            this.purgeQueue(queueName);
        }
    }

    @ManagedOperation(description="Purge a queue and return the number of messages purged")
    public int purgeQueue(String queueName) {
        return this.rabbitTemplate.execute(channel -> {
            AMQP.Queue.PurgeOk queuePurged = channel.queuePurge(queueName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Purged queue: " + queueName + ", " + queuePurged));
            }
            return queuePurged.getMessageCount();
        });
    }

    @ManagedOperation(description="Declare a binding on the broker (this operation is not available remotely)")
    public void declareBinding(Binding binding) {
        try {
            this.rabbitTemplate.execute(channel -> {
                this.declareBindings(channel, binding);
                if (this.redeclareManualDeclarations) {
                    this.manualDeclarables.add((Declarable)binding);
                }
                return null;
            });
        }
        catch (AmqpException e) {
            this.logOrRethrowDeclarationException((Declarable)binding, "binding", e);
        }
    }

    @ManagedOperation(description="Remove a binding from the broker (this operation is not available remotely)")
    public void removeBinding(Binding binding) {
        this.rabbitTemplate.execute(channel -> {
            if (binding.isDestinationQueue()) {
                if (this.isRemovingImplicitQueueBinding(binding)) {
                    return null;
                }
                channel.queueUnbind(binding.getDestination(), binding.getExchange(), binding.getRoutingKey(), binding.getArguments());
            } else {
                channel.exchangeUnbind(binding.getDestination(), binding.getExchange(), binding.getRoutingKey(), binding.getArguments());
            }
            this.manualDeclarables.remove(binding.toString());
            return null;
        });
    }

    @ManagedOperation(description="Get queue name, message count and consumer count")
    public Properties getQueueProperties(String queueName) {
        QueueInformation queueInfo = this.getQueueInfo(queueName);
        if (queueInfo != null) {
            Properties props = new Properties();
            props.put(QUEUE_NAME, queueInfo.getName());
            props.put(QUEUE_MESSAGE_COUNT, (Object)queueInfo.getMessageCount());
            props.put(QUEUE_CONSUMER_COUNT, (Object)queueInfo.getConsumerCount());
            return props;
        }
        return null;
    }

    public QueueInformation getQueueInfo(String queueName) {
        Assert.hasText((String)queueName, (String)"'queueName' cannot be null or empty");
        return this.rabbitTemplate.execute(channel -> {
            try {
                AMQP.Queue.DeclareOk declareOk = channel.queueDeclarePassive(queueName);
                return new QueueInformation(declareOk.getQueue(), declareOk.getMessageCount(), declareOk.getConsumerCount());
            }
            catch (IllegalArgumentException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.error((Object)("Exception while fetching Queue properties: '" + queueName + "'"), (Throwable)e);
                }
                try {
                    if (channel instanceof ChannelProxy) {
                        ChannelProxy proxy = (ChannelProxy)channel;
                        proxy.getTargetChannel().close();
                    }
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                return null;
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Queue '" + queueName + "' does not exist"));
                }
                return null;
            }
        });
    }

    public void setExplicitDeclarationsOnly(boolean explicitDeclarationsOnly) {
        this.explicitDeclarationsOnly = explicitDeclarationsOnly;
    }

    public boolean isRedeclareManualDeclarations() {
        return this.redeclareManualDeclarations;
    }

    public void setRedeclareManualDeclarations(boolean redeclareManualDeclarations) {
        this.redeclareManualDeclarations = redeclareManualDeclarations;
    }

    public void setRetryTemplate(@Nullable RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
        if (retryTemplate == null) {
            this.retryDisabled = true;
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void afterPropertiesSet() {
        this.lifecycleLock.lock();
        try {
            CachingConnectionFactory ccf;
            ConnectionFactory connectionFactory;
            if (this.running || !this.autoStartup) {
                return;
            }
            if (this.retryTemplate == null && !this.retryDisabled) {
                this.retryTemplate = new RetryTemplate();
                this.retryTemplate.setRetryPolicy((RetryPolicy)new SimpleRetryPolicy(5));
                ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
                backOffPolicy.setInitialInterval(1000L);
                backOffPolicy.setMultiplier(2.0);
                backOffPolicy.setMaxInterval(5000L);
                this.retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
            }
            if ((connectionFactory = this.connectionFactory) instanceof CachingConnectionFactory && (ccf = (CachingConnectionFactory)connectionFactory).getCacheMode() == CachingConnectionFactory.CacheMode.CONNECTION) {
                this.logger.warn((Object)"RabbitAdmin auto declaration is not supported with CacheMode.CONNECTION");
                return;
            }
            AtomicBoolean initializing = new AtomicBoolean(false);
            this.connectionFactory.addConnectionListener(connection -> {
                if (!initializing.compareAndSet(false, true)) {
                    return;
                }
                try {
                    if (this.retryTemplate != null) {
                        this.retryTemplate.execute(c -> {
                            this.initialize();
                            return null;
                        });
                    } else {
                        this.initialize();
                    }
                }
                finally {
                    initializing.compareAndSet(true, false);
                }
            });
            this.running = true;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    public void initialize() {
        this.redeclareBeanDeclarables();
        this.redeclareManualDeclarables();
    }

    private void redeclareBeanDeclarables() {
        if (this.applicationContext == null) {
            this.logger.debug((Object)"no ApplicationContext has been set, cannot auto-declare Exchanges, Queues, and Bindings");
            return;
        }
        this.logger.debug((Object)"Initializing declarations");
        LinkedList<Exchange> contextExchanges = new LinkedList<Exchange>(this.applicationContext.getBeansOfType(Exchange.class).values());
        LinkedList<Queue> contextQueues = new LinkedList<Queue>(this.applicationContext.getBeansOfType(Queue.class).values());
        LinkedList<Binding> contextBindings = new LinkedList<Binding>(this.applicationContext.getBeansOfType(Binding.class).values());
        Collection<DeclarableCustomizer> customizers = this.applicationContext.getBeansOfType(DeclarableCustomizer.class).values();
        this.processDeclarables(contextExchanges, contextQueues, contextBindings);
        Collection<Exchange> exchanges = this.filterDeclarables(contextExchanges, customizers);
        Collection<Queue> queues = this.filterDeclarables(contextQueues, customizers);
        Collection<Binding> bindings = this.filterDeclarables(contextBindings, customizers);
        for (Exchange exchange : exchanges) {
            if (exchange.isDurable() && !exchange.isAutoDelete() || !this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("Auto-declaring a non-durable or auto-delete Exchange (" + exchange.getName() + ") durable:" + exchange.isDurable() + ", auto-delete:" + exchange.isAutoDelete() + ". It will be deleted by the broker if it shuts down, and can be redeclared by closing and reopening the connection."));
        }
        for (Queue queue : queues) {
            if (queue.isDurable() && !queue.isAutoDelete() && !queue.isExclusive() || !this.logger.isInfoEnabled()) continue;
            this.logger.info((Object)("Auto-declaring a non-durable, auto-delete, or exclusive Queue (" + queue.getName() + ") durable:" + queue.isDurable() + ", auto-delete:" + queue.isAutoDelete() + ", exclusive:" + queue.isExclusive() + ". It will be redeclared if the broker stops and is restarted while the connection factory is alive, but all messages will be lost."));
        }
        if (exchanges.isEmpty() && queues.isEmpty() && bindings.isEmpty() && this.manualDeclarables.isEmpty()) {
            this.logger.debug((Object)"Nothing to declare");
            return;
        }
        this.rabbitTemplate.execute(channel -> {
            this.declareExchanges(channel, exchanges.toArray(new Exchange[0]));
            this.declareQueues(channel, queues.toArray(new Queue[0]));
            this.declareBindings(channel, bindings.toArray(new Binding[0]));
            return null;
        });
        this.logger.debug((Object)"Declarations finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redeclareManualDeclarables() {
        if (!this.manualDeclarables.isEmpty()) {
            this.manualDeclarablesLock.lock();
            try {
                this.logger.debug((Object)"Redeclaring manually declared Declarables");
                for (Declarable dec : this.manualDeclarables) {
                    if (dec instanceof Queue) {
                        Queue queue = (Queue)dec;
                        this.declareQueue(queue);
                        continue;
                    }
                    if (dec instanceof Exchange) {
                        Exchange exch = (Exchange)dec;
                        this.declareExchange(exch);
                        continue;
                    }
                    this.declareBinding((Binding)dec);
                }
            }
            finally {
                this.manualDeclarablesLock.unlock();
            }
        }
    }

    public void resetAllManualDeclarations() {
        this.manualDeclarables.clear();
    }

    @Deprecated
    public Map<String, Declarable> getManualDeclarables() {
        HashMap<String, Declarable> declarables = new HashMap<String, Declarable>();
        this.manualDeclarables.forEach(declarable -> {
            if (declarable instanceof Exchange) {
                Exchange exch = (Exchange)declarable;
                declarables.put(exch.getName(), (Declarable)declarable);
            } else if (declarable instanceof Queue) {
                Queue queue = (Queue)declarable;
                declarables.put(queue.getName(), (Declarable)declarable);
            } else if (declarable instanceof Binding) {
                declarables.put(declarable.toString(), (Declarable)declarable);
            }
        });
        return declarables;
    }

    public Set<Declarable> getManualDeclarableSet() {
        return Collections.unmodifiableSet(this.manualDeclarables);
    }

    private void processDeclarables(Collection<Exchange> contextExchanges, Collection<Queue> contextQueues, Collection<Binding> contextBindings) {
        Collection declarables = this.applicationContext.getBeansOfType(Declarables.class, false, true).values();
        declarables.forEach(d -> d.getDeclarables().forEach(declarable -> {
            if (declarable instanceof Exchange) {
                Exchange exch = (Exchange)declarable;
                contextExchanges.add(exch);
            } else if (declarable instanceof Queue) {
                Queue queue = (Queue)declarable;
                contextQueues.add(queue);
            } else if (declarable instanceof Binding) {
                Binding binding = (Binding)declarable;
                contextBindings.add(binding);
            }
        }));
    }

    private <T extends Declarable> Collection<T> filterDeclarables(Collection<T> declarables, Collection<DeclarableCustomizer> customizers) {
        return declarables.stream().filter(dec -> dec.shouldDeclare() && this.declarableByMe(dec)).map(dec -> {
            if (customizers.isEmpty()) {
                return dec;
            }
            AtomicReference<Declarable> ref = new AtomicReference<Declarable>((Declarable)dec);
            customizers.forEach(cust -> ref.set((Declarable)cust.apply((Object)((Declarable)ref.get()))));
            return ref.get();
        }).toList();
    }

    private <T extends Declarable> boolean declarableByMe(T dec) {
        return dec.getDeclaringAdmins().isEmpty() && !this.explicitDeclarationsOnly || dec.getDeclaringAdmins().contains(this) || this.beanName != null && dec.getDeclaringAdmins().contains(this.beanName);
    }

    private void declareExchanges(Channel channel, Exchange ... exchanges) throws IOException {
        for (Exchange exchange : exchanges) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("declaring Exchange '" + exchange.getName() + "'"));
            }
            if (this.isDeclaringDefaultExchange(exchange)) continue;
            try {
                if (exchange.isDelayed()) {
                    HashMap<String, String> arguments = exchange.getArguments();
                    arguments = arguments == null ? new HashMap<String, String>() : new HashMap(arguments);
                    arguments.put("x-delayed-type", exchange.getType());
                    channel.exchangeDeclare(exchange.getName(), DELAYED_MESSAGE_EXCHANGE, exchange.isDurable(), exchange.isAutoDelete(), exchange.isInternal(), arguments);
                    continue;
                }
                channel.exchangeDeclare(exchange.getName(), exchange.getType(), exchange.isDurable(), exchange.isAutoDelete(), exchange.isInternal(), exchange.getArguments());
            }
            catch (IOException e) {
                this.logOrRethrowDeclarationException((Declarable)exchange, "exchange", e);
            }
        }
    }

    private AMQP.Queue.DeclareOk[] declareQueues(Channel channel, Queue ... queues) throws IOException {
        ArrayList<AMQP.Queue.DeclareOk> declareOks = new ArrayList<AMQP.Queue.DeclareOk>(queues.length);
        for (Queue queue : queues) {
            if (!queue.getName().startsWith("amq.")) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("declaring Queue '" + queue.getName() + "'"));
                }
                try {
                    try {
                        AMQP.Queue.DeclareOk declareOk = channel.queueDeclare(queue.getName(), queue.isDurable(), queue.isExclusive(), queue.isAutoDelete(), queue.getArguments());
                        if (StringUtils.hasText((String)declareOk.getQueue())) {
                            queue.setActualName(declareOk.getQueue());
                        }
                        declareOks.add(declareOk);
                    }
                    catch (IllegalArgumentException e) {
                        this.closeChannelAfterIllegalArg(channel, queue);
                        throw new IOException(e);
                    }
                }
                catch (IOException e) {
                    this.logOrRethrowDeclarationException((Declarable)queue, "queue", e);
                }
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)(queue.getName() + ": Queue with name that starts with 'amq.' cannot be declared."));
        }
        return declareOks.toArray(new AMQP.Queue.DeclareOk[0]);
    }

    private void closeChannelAfterIllegalArg(Channel channel, Queue queue) {
        if (this.logger.isDebugEnabled()) {
            this.logger.error((Object)("Exception while declaring queue: '" + queue.getName() + "'"));
        }
        try {
            if (channel instanceof ChannelProxy) {
                ChannelProxy proxy = (ChannelProxy)channel;
                proxy.getTargetChannel().close();
            }
        }
        catch (IOException | TimeoutException e1) {
            this.logger.error((Object)"Failed to close channel after illegal argument", (Throwable)e1);
        }
    }

    private void declareBindings(Channel channel, Binding ... bindings) throws IOException {
        for (Binding binding : bindings) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Binding destination [" + binding.getDestination() + " (" + binding.getDestinationType() + ")] to exchange [" + binding.getExchange() + "] with routing key [" + binding.getRoutingKey() + "]"));
            }
            try {
                if (binding.isDestinationQueue()) {
                    if (this.isDeclaringImplicitQueueBinding(binding)) continue;
                    channel.queueBind(binding.getDestination(), binding.getExchange(), binding.getRoutingKey(), binding.getArguments());
                    continue;
                }
                channel.exchangeBind(binding.getDestination(), binding.getExchange(), binding.getRoutingKey(), binding.getArguments());
            }
            catch (IOException e) {
                this.logOrRethrowDeclarationException((Declarable)binding, "binding", e);
            }
        }
    }

    private <T extends Throwable> void logOrRethrowDeclarationException(@Nullable Declarable element, String elementType, T t) throws T {
        this.publishDeclarationExceptionEvent(element, t);
        if (this.ignoreDeclarationExceptions || element != null && element.isIgnoreDeclarationExceptions()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Failed to declare " + elementType + ": " + (element == null ? "broker-generated" : element) + ", continuing..."), t);
            } else if (this.logger.isWarnEnabled()) {
                Object cause = t;
                if (t instanceof IOException && t.getCause() != null) {
                    cause = t.getCause();
                }
                this.logger.warn((Object)("Failed to declare " + elementType + ": " + (element == null ? "broker-generated" : element) + ", continuing... " + cause));
            }
        } else {
            throw t;
        }
    }

    private <T extends Throwable> void publishDeclarationExceptionEvent(@Nullable Declarable element, T t) {
        DeclarationExceptionEvent event;
        this.lastDeclarationExceptionEvent = event = new DeclarationExceptionEvent(this, element, t);
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        }
    }

    private boolean isDeclaringDefaultExchange(Exchange exchange) {
        if (this.isDefaultExchange(exchange.getName())) {
            this.logger.debug((Object)"Default exchange is pre-declared by server.");
            return true;
        }
        return false;
    }

    private boolean isDeletingDefaultExchange(String exchangeName) {
        if (this.isDefaultExchange(exchangeName)) {
            this.logger.debug((Object)"Default exchange cannot be deleted.");
            return true;
        }
        return false;
    }

    private boolean isDefaultExchange(String exchangeName) {
        return DEFAULT_EXCHANGE_NAME.equals(exchangeName);
    }

    private boolean isDeclaringImplicitQueueBinding(Binding binding) {
        if (this.isImplicitQueueBinding(binding)) {
            this.logger.debug((Object)"The default exchange is implicitly bound to every queue, with a routing key equal to the queue name.");
            return true;
        }
        return false;
    }

    private boolean isRemovingImplicitQueueBinding(Binding binding) {
        if (this.isImplicitQueueBinding(binding)) {
            this.logger.debug((Object)"Cannot remove implicit default exchange binding to queue.");
            return true;
        }
        return false;
    }

    private boolean isImplicitQueueBinding(Binding binding) {
        return this.isDefaultExchange(binding.getExchange()) && binding.getDestination().equals(binding.getRoutingKey());
    }
}

