/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.config.ListenerContainerFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public final class RabbitNamespaceUtils {
    private static final String CONNECTION_FACTORY_ATTRIBUTE = "connection-factory";
    private static final String TASK_EXECUTOR_ATTRIBUTE = "task-executor";
    private static final String ERROR_HANDLER_ATTRIBUTE = "error-handler";
    private static final String ACKNOWLEDGE_ATTRIBUTE = "acknowledge";
    private static final String ACKNOWLEDGE_AUTO = "auto";
    private static final String ACKNOWLEDGE_MANUAL = "manual";
    private static final String ACKNOWLEDGE_NONE = "none";
    private static final String TRANSACTION_MANAGER_ATTRIBUTE = "transaction-manager";
    private static final String CONCURRENCY_ATTRIBUTE = "concurrency";
    private static final String MAX_CONCURRENCY_ATTRIBUTE = "max-concurrency";
    private static final String MIN_START_INTERVAL_ATTRIBUTE = "min-start-interval";
    private static final String MIN_STOP_INTERVAL_ATTRIBUTE = "min-stop-interval";
    private static final String MIN_CONSECUTIVE_ACTIVE_ATTRIBUTE = "min-consecutive-active";
    private static final String MIN_CONSECUTIVE_IDLE_ATTRIBUTE = "min-consecutive-idle";
    private static final String PREFETCH_ATTRIBUTE = "prefetch";
    private static final String GLOBAL_QOS = "global-qos";
    private static final String RECEIVE_TIMEOUT_ATTRIBUTE = "receive-timeout";
    private static final String CHANNEL_TRANSACTED_ATTRIBUTE = "channel-transacted";
    private static final String TRANSACTION_SIZE_ATTRIBUTE = "transaction-size";
    private static final String CONSUMER_BATCH_ENABLED_ATTRIBUTE = "consumer-batch-enabled";
    private static final String BATCH_SIZE_ATTRIBUTE = "batch-size";
    private static final String PHASE_ATTRIBUTE = "phase";
    private static final String AUTO_STARTUP_ATTRIBUTE = "auto-startup";
    private static final String ADVICE_CHAIN_ATTRIBUTE = "advice-chain";
    private static final String REQUEUE_REJECTED_ATTRIBUTE = "requeue-rejected";
    private static final String RECOVERY_INTERVAL = "recovery-interval";
    private static final String RECOVERY_BACK_OFF = "recovery-back-off";
    private static final String MISSING_QUEUES_FATAL = "missing-queues-fatal";
    private static final String POSSIBLE_AUTHENTICATION_FAILURE_FATAL = "possible-authentication-failure-fatal";
    private static final String MISMATCHED_QUEUES_FATAL = "mismatched-queues-fatal";
    private static final String AUTO_DECLARE = "auto-declare";
    private static final String DECLARATION_RETRIES = "declaration-retries";
    private static final String FAILED_DECLARATION_RETRY_INTERVAL = "failed-declaration-retry-interval";
    private static final String MISSING_QUEUE_RETRY_INTERVAL = "missing-queue-retry-interval";
    private static final String CONSUMER_TAG_STRATEGY = "consumer-tag-strategy";
    private static final String IDLE_EVENT_INTERVAL = "idle-event-interval";
    private static final String CONSUMERS_PER_QUEUE = "consumers-per-queue";
    private static final String TASK_SCHEDULER = "task-scheduler";
    private static final String MONITOR_INTERVAL = "monitor-interval";
    private static final String TYPE = "type";
    private static final String AFTER_RECEIVE_POST_PROCESSORS = "after-receive-post-processors";

    private RabbitNamespaceUtils() {
    }

    public static BeanDefinition parseContainer(Element containerEle, ParserContext parserContext) {
        String afterReceivePostProcessors;
        String monitorInterval;
        String taskScheduler;
        String consumersPerQueue;
        String idleEventInterval;
        String consumerTagStrategy;
        String retryDeclarationInterval;
        String failedDeclarationRetryInterval;
        String declarationRetries;
        String autoDeclare;
        String mismatchedQueuesFatal;
        String possibleAuthenticationFailureFatal;
        String missingQueuesFatal;
        String adviceChain;
        String autoStartup;
        String phase;
        String requeueRejected;
        String transactionSize;
        String batchSize;
        String consumerBatch;
        String channelTransacted;
        String receiveTimeout;
        String globalQos;
        String prefetch;
        String minConsecutiveIdle;
        String minConsecutiveMessages;
        String minStopInterval;
        String minStartInterval;
        String maxConcurrency;
        String concurrency;
        String transactionManagerBeanName;
        AcknowledgeMode acknowledgeMode;
        String errorHandlerBeanName;
        String taskExecutorBeanName;
        String type;
        RootBeanDefinition containerDef = new RootBeanDefinition(ListenerContainerFactoryBean.class);
        containerDef.setSource(parserContext.extractSource((Object)containerEle));
        String connectionFactoryBeanName = "rabbitConnectionFactory";
        if (containerEle.hasAttribute(CONNECTION_FACTORY_ATTRIBUTE) && !StringUtils.hasText((String)(connectionFactoryBeanName = containerEle.getAttribute(CONNECTION_FACTORY_ATTRIBUTE)))) {
            parserContext.getReaderContext().error("Listener container 'connection-factory' attribute contains empty value.", (Object)containerEle);
        }
        if (StringUtils.hasText((String)connectionFactoryBeanName)) {
            containerDef.getPropertyValues().add("connectionFactory", (Object)new RuntimeBeanReference(connectionFactoryBeanName));
        }
        if (containerEle.hasAttribute(TYPE) && StringUtils.hasText((String)(type = containerEle.getAttribute(TYPE)))) {
            containerDef.getPropertyValues().add(TYPE, (Object)new TypedStringValue(type));
        }
        if (StringUtils.hasText((String)(taskExecutorBeanName = containerEle.getAttribute(TASK_EXECUTOR_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("taskExecutor", (Object)new RuntimeBeanReference(taskExecutorBeanName));
        }
        if (StringUtils.hasText((String)(errorHandlerBeanName = containerEle.getAttribute(ERROR_HANDLER_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("errorHandler", (Object)new RuntimeBeanReference(errorHandlerBeanName));
        }
        if ((acknowledgeMode = RabbitNamespaceUtils.parseAcknowledgeMode(containerEle, parserContext)) != null) {
            containerDef.getPropertyValues().add("acknowledgeMode", (Object)acknowledgeMode);
        }
        if (StringUtils.hasText((String)(transactionManagerBeanName = containerEle.getAttribute(TRANSACTION_MANAGER_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("transactionManager", (Object)new RuntimeBeanReference(transactionManagerBeanName));
        }
        if (StringUtils.hasText((String)(concurrency = containerEle.getAttribute(CONCURRENCY_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("concurrentConsumers", (Object)new TypedStringValue(concurrency));
        }
        if (StringUtils.hasText((String)(maxConcurrency = containerEle.getAttribute(MAX_CONCURRENCY_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("maxConcurrentConsumers", (Object)new TypedStringValue(maxConcurrency));
        }
        if (StringUtils.hasText((String)(minStartInterval = containerEle.getAttribute(MIN_START_INTERVAL_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("startConsumerMinInterval", (Object)new TypedStringValue(minStartInterval));
        }
        if (StringUtils.hasText((String)(minStopInterval = containerEle.getAttribute(MIN_STOP_INTERVAL_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("stopConsumerMinInterval", (Object)new TypedStringValue(minStopInterval));
        }
        if (StringUtils.hasText((String)(minConsecutiveMessages = containerEle.getAttribute(MIN_CONSECUTIVE_ACTIVE_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("consecutiveActiveTrigger", (Object)new TypedStringValue(minConsecutiveMessages));
        }
        if (StringUtils.hasText((String)(minConsecutiveIdle = containerEle.getAttribute(MIN_CONSECUTIVE_IDLE_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("consecutiveIdleTrigger", (Object)new TypedStringValue(minConsecutiveIdle));
        }
        if (StringUtils.hasText((String)(prefetch = containerEle.getAttribute(PREFETCH_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("prefetchCount", (Object)new TypedStringValue(prefetch));
        }
        if (StringUtils.hasText((String)(globalQos = containerEle.getAttribute(GLOBAL_QOS)))) {
            containerDef.getPropertyValues().add("globalQos", (Object)new TypedStringValue(globalQos));
        }
        if (StringUtils.hasText((String)(receiveTimeout = containerEle.getAttribute(RECEIVE_TIMEOUT_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("receiveTimeout", (Object)new TypedStringValue(receiveTimeout));
        }
        if (StringUtils.hasText((String)(channelTransacted = containerEle.getAttribute(CHANNEL_TRANSACTED_ATTRIBUTE)))) {
            if (AcknowledgeMode.NONE == acknowledgeMode && channelTransacted.equalsIgnoreCase("true")) {
                parserContext.getReaderContext().error("Listener Container - cannot set channel-transacted with acknowledge='NONE'", (Object)containerEle);
            }
            containerDef.getPropertyValues().add("channelTransacted", (Object)new TypedStringValue(channelTransacted));
        }
        if (StringUtils.hasText((String)(consumerBatch = containerEle.getAttribute(CONSUMER_BATCH_ENABLED_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("consumerBatchEnabled", (Object)new TypedStringValue(consumerBatch));
        }
        if (StringUtils.hasText((String)(batchSize = containerEle.getAttribute(BATCH_SIZE_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("batchSize", (Object)new TypedStringValue(batchSize));
        }
        if (StringUtils.hasText((String)(transactionSize = containerEle.getAttribute(TRANSACTION_SIZE_ATTRIBUTE)))) {
            if (StringUtils.hasText((String)batchSize)) {
                parserContext.getReaderContext().error("Listener Container - cannot have both 'batch-size' and 'transaction-size'", (Object)containerEle);
            }
            containerDef.getPropertyValues().add("batchSize", (Object)new TypedStringValue(transactionSize));
        }
        if (StringUtils.hasText((String)(requeueRejected = containerEle.getAttribute(REQUEUE_REJECTED_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("defaultRequeueRejected", (Object)new TypedStringValue(requeueRejected));
        }
        if (StringUtils.hasText((String)(phase = containerEle.getAttribute(PHASE_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add(PHASE_ATTRIBUTE, (Object)phase);
        }
        if (StringUtils.hasText((String)(autoStartup = containerEle.getAttribute(AUTO_STARTUP_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("autoStartup", (Object)new TypedStringValue(autoStartup));
        }
        if (StringUtils.hasText((String)(adviceChain = containerEle.getAttribute(ADVICE_CHAIN_ATTRIBUTE)))) {
            containerDef.getPropertyValues().add("adviceChain", (Object)new RuntimeBeanReference(adviceChain));
        }
        String recoveryInterval = containerEle.getAttribute(RECOVERY_INTERVAL);
        String recoveryBackOff = containerEle.getAttribute(RECOVERY_BACK_OFF);
        if (StringUtils.hasText((String)recoveryInterval)) {
            if (StringUtils.hasText((String)recoveryBackOff)) {
                parserContext.getReaderContext().error("'recovery-interval' and 'recovery-back-off' are mutually exclusive", (Object)containerEle);
            }
            containerDef.getPropertyValues().add("recoveryInterval", (Object)new TypedStringValue(recoveryInterval));
        }
        if (StringUtils.hasText((String)recoveryBackOff)) {
            containerDef.getPropertyValues().add("recoveryBackOff", (Object)new RuntimeBeanReference(recoveryBackOff));
        }
        if (StringUtils.hasText((String)(missingQueuesFatal = containerEle.getAttribute(MISSING_QUEUES_FATAL)))) {
            containerDef.getPropertyValues().add("missingQueuesFatal", (Object)new TypedStringValue(missingQueuesFatal));
        }
        if (StringUtils.hasText((String)(possibleAuthenticationFailureFatal = containerEle.getAttribute(POSSIBLE_AUTHENTICATION_FAILURE_FATAL)))) {
            containerDef.getPropertyValues().add("possibleAuthenticationFailureFatal", (Object)new TypedStringValue(possibleAuthenticationFailureFatal));
        }
        if (StringUtils.hasText((String)(mismatchedQueuesFatal = containerEle.getAttribute(MISMATCHED_QUEUES_FATAL)))) {
            containerDef.getPropertyValues().add("mismatchedQueuesFatal", (Object)new TypedStringValue(mismatchedQueuesFatal));
        }
        if (StringUtils.hasText((String)(autoDeclare = containerEle.getAttribute(AUTO_DECLARE)))) {
            containerDef.getPropertyValues().add("autoDeclare", (Object)new TypedStringValue(autoDeclare));
        }
        if (StringUtils.hasText((String)(declarationRetries = containerEle.getAttribute(DECLARATION_RETRIES)))) {
            containerDef.getPropertyValues().add("declarationRetries", (Object)new TypedStringValue(declarationRetries));
        }
        if (StringUtils.hasText((String)(failedDeclarationRetryInterval = containerEle.getAttribute(FAILED_DECLARATION_RETRY_INTERVAL)))) {
            containerDef.getPropertyValues().add("failedDeclarationRetryInterval", (Object)new TypedStringValue(failedDeclarationRetryInterval));
        }
        if (StringUtils.hasText((String)(retryDeclarationInterval = containerEle.getAttribute(MISSING_QUEUE_RETRY_INTERVAL)))) {
            containerDef.getPropertyValues().add("retryDeclarationInterval", (Object)new TypedStringValue(retryDeclarationInterval));
        }
        if (StringUtils.hasText((String)(consumerTagStrategy = containerEle.getAttribute(CONSUMER_TAG_STRATEGY)))) {
            containerDef.getPropertyValues().add("consumerTagStrategy", (Object)new RuntimeBeanReference(consumerTagStrategy));
        }
        if (StringUtils.hasText((String)(idleEventInterval = containerEle.getAttribute(IDLE_EVENT_INTERVAL)))) {
            containerDef.getPropertyValues().add("idleEventInterval", (Object)new TypedStringValue(idleEventInterval));
        }
        if (StringUtils.hasText((String)(consumersPerQueue = containerEle.getAttribute(CONSUMERS_PER_QUEUE)))) {
            containerDef.getPropertyValues().add("consumersPerQueue", (Object)new TypedStringValue(consumersPerQueue));
        }
        if (StringUtils.hasText((String)(taskScheduler = containerEle.getAttribute(TASK_SCHEDULER)))) {
            containerDef.getPropertyValues().add("taskScheduler", (Object)new RuntimeBeanReference(taskScheduler));
        }
        if (StringUtils.hasText((String)(monitorInterval = containerEle.getAttribute(MONITOR_INTERVAL)))) {
            containerDef.getPropertyValues().add("monitorInterval", (Object)new TypedStringValue(monitorInterval));
        }
        if (StringUtils.hasText((String)(afterReceivePostProcessors = containerEle.getAttribute(AFTER_RECEIVE_POST_PROCESSORS)))) {
            String[] names = StringUtils.delimitedListToStringArray((String)afterReceivePostProcessors, (String)",", (String)" ");
            ManagedList values = new ManagedList();
            for (String name : names) {
                values.add(new RuntimeBeanReference(name));
            }
            containerDef.getPropertyValues().add("afterReceivePostProcessors", (Object)values);
        }
        return containerDef;
    }

    private static AcknowledgeMode parseAcknowledgeMode(Element ele, ParserContext parserContext) {
        String acknowledge = ele.getAttribute(ACKNOWLEDGE_ATTRIBUTE);
        if (StringUtils.hasText((String)acknowledge)) {
            return switch (acknowledge) {
                case ACKNOWLEDGE_AUTO -> AcknowledgeMode.AUTO;
                case ACKNOWLEDGE_MANUAL -> AcknowledgeMode.MANUAL;
                case ACKNOWLEDGE_NONE -> AcknowledgeMode.NONE;
                default -> {
                    parserContext.getReaderContext().error("Invalid listener container 'acknowledge' setting [" + acknowledge + "]: only \"auto\", \"manual\", and \"none\" supported.", (Object)ele);
                    yield null;
                }
            };
        }
        return null;
    }
}

