/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.analytics.rest.domain;

import java.util.Date;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Metric<T extends Number> {
    private final String name;
    private final T value;
    private final Date timestamp;

    public Metric(String name, T value) {
        this(name, value, new Date());
    }

    public Metric(String name, T value, Date timestamp) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.name = name;
        this.value = value;
        this.timestamp = timestamp;
    }

    public String getName() {
        return this.name;
    }

    public T getValue() {
        return this.value;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "Metric [name=" + this.name + ", value=" + this.value + ", timestamp=" + this.timestamp + "]";
    }

    public Metric<Long> increment(int amount) {
        return new Metric<Long>(this.getName(), ((Number)this.getValue()).longValue() + (long)amount);
    }

    public <S extends Number> Metric<S> set(S value) {
        return new Metric<S>(this.getName(), value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.name);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.timestamp);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Metric) {
            Metric other = (Metric)obj;
            boolean rtn = true;
            rtn = rtn && ObjectUtils.nullSafeEquals((Object)this.name, (Object)other.name);
            rtn = rtn && ObjectUtils.nullSafeEquals((Object)this.timestamp, (Object)other.timestamp);
            rtn = rtn && ObjectUtils.nullSafeEquals(this.value, other.value);
            return rtn;
        }
        return super.equals(obj);
    }
}

