/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.extensions.excel.poi;

import java.io.File;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.batch.extensions.excel.AbstractExcelItemReader;
import org.springframework.batch.extensions.excel.Sheet;
import org.springframework.batch.extensions.excel.poi.PoiSheet;
import org.springframework.core.io.Resource;

public class PoiItemReader<T>
extends AbstractExcelItemReader<T> {
    private Workbook workbook;
    private InputStream inputStream;
    private boolean datesAsIso = false;

    @Override
    protected Sheet getSheet(int sheet) {
        return new PoiSheet(this.workbook.getSheetAt(sheet), this.datesAsIso);
    }

    @Override
    protected int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    @Override
    protected void doClose() throws Exception {
        super.doClose();
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        if (this.workbook != null) {
            this.workbook.close();
            this.workbook = null;
        }
    }

    @Override
    protected void openExcelFile(Resource resource, String password) throws Exception {
        if (resource.isFile()) {
            File file = resource.getFile();
            this.workbook = WorkbookFactory.create((File)file, (String)password, (boolean)false);
        } else {
            this.inputStream = resource.getInputStream();
            this.workbook = WorkbookFactory.create((InputStream)this.inputStream, (String)password);
        }
        this.workbook.setMissingCellPolicy(Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
    }

    public void setDatesAsIso(boolean datesAsIso) {
        this.datesAsIso = datesAsIso;
    }
}

