/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.extensions.excel.streaming;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.model.StylesTable;
import org.springframework.batch.extensions.excel.AbstractExcelItemReader;
import org.springframework.batch.extensions.excel.Sheet;
import org.springframework.batch.extensions.excel.streaming.StreamingSheet;
import org.springframework.core.io.Resource;
import org.xml.sax.SAXException;

public class StreamingXlsxItemReader<T>
extends AbstractExcelItemReader<T> {
    private final List<StreamingSheet> sheets = new ArrayList<StreamingSheet>();
    private OPCPackage pkg;
    private InputStream inputStream;

    @Override
    protected Sheet getSheet(int sheet) {
        return this.sheets.get(sheet);
    }

    @Override
    protected int getNumberOfSheets() {
        return this.sheets.size();
    }

    @Override
    protected void openExcelFile(Resource resource, String password) throws Exception {
        if (resource.isFile()) {
            File file = resource.getFile();
            this.pkg = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);
        } else {
            this.inputStream = resource.getInputStream();
            this.pkg = OPCPackage.open((InputStream)this.inputStream);
        }
        XSSFReader reader = new XSSFReader(this.pkg);
        this.initSheets(reader, this.pkg);
    }

    private void initSheets(XSSFReader reader, OPCPackage pkg) throws IOException, InvalidFormatException {
        ReadOnlySharedStringsTable sharedStrings;
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)reader.getSheetsData();
        try {
            sharedStrings = new ReadOnlySharedStringsTable(pkg);
        }
        catch (SAXException ex) {
            throw new IllegalStateException("Cannot read shared-strings-table.", ex);
        }
        StylesTable styles = reader.getStylesTable();
        while (iter.hasNext()) {
            InputStream is = iter.next();
            String name = iter.getSheetName();
            this.sheets.add(new StreamingSheet(name, is, (SharedStrings)sharedStrings, (Styles)styles));
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Prepared " + this.sheets.size() + " sheets."));
        }
    }

    @Override
    protected void doClose() throws Exception {
        this.pkg.revert();
        for (StreamingSheet sheet : this.sheets) {
            sheet.close();
        }
        this.sheets.clear();
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
        super.doClose();
    }
}

