/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.integration;

import org.springframework.batch.admin.integration.JobConfigurationRequest;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.util.StringUtils;

@MessageEndpoint
public class JobConfigurationRequestToResourceAdapter {
    private static final String EMPTY_BEANS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><beans xmlns=\"http://www.springframework.org/schema/beans\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.5.xsd\"/>";

    @ServiceActivator
    public Resource adapt(JobConfigurationRequest request) throws DuplicateJobException {
        String filename = request.getFilename();
        if (!StringUtils.hasText((String)request.getXml())) {
            return new ByteArrayResource(EMPTY_BEANS.getBytes(), filename + ":empty-string");
        }
        return new ByteArrayResource(request.getXml().getBytes(), filename);
    }
}

