/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.integration;

import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.integration.launch.JobLaunchRequest;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@MessageEndpoint
public class StringToJobLaunchRequestAdapter
implements InitializingBean {
    private JobLocator jobLocator;
    private JobParametersConverter converter = new DefaultJobParametersConverter();
    private static String PATTERN = "([\\w-_]*)(\\[(.*)\\]|.*)";

    public void setJobLocator(JobLocator jobLocator) {
        this.jobLocator = jobLocator;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.jobLocator != null ? 1 : 0) != 0, (String)"A JobLocator must be provided");
    }

    @ServiceActivator
    public JobLaunchRequest adapt(String request) throws NoSuchJobException {
        request = request.trim();
        Assert.isTrue((boolean)request.matches(PATTERN), (String)("Input in wrong format (" + request + "): use jobname([(key=value(,key=value)*])"));
        String jobName = request.replaceAll(PATTERN, "$1");
        Job job = this.jobLocator.getJob(jobName);
        String paramsText = request.replaceAll(PATTERN, "$3");
        JobParameters jobParameters = this.converter.getJobParameters(StringUtils.splitArrayElementsIntoProperties((String[])paramsText.split(","), (String)"="));
        return new JobLaunchRequest(job, jobParameters);
    }
}

