/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.batch.item.adapter.DynamicMethodInvocationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.MethodInvoker;

public class AbstractMethodInvokingDelegator
implements InitializingBean {
    private Object targetObject;
    private String targetMethod;
    private Object[] arguments;

    protected Object invokeDelegateMethod() {
        MethodInvoker invoker = this.createMethodInvoker(this.targetObject, this.targetMethod);
        invoker.setArguments(this.arguments);
        return this.doInvoke(invoker);
    }

    protected Object invokeDelegateMethodWithArgument(Object object) {
        MethodInvoker invoker = this.createMethodInvoker(this.targetObject, this.targetMethod);
        invoker.setArguments(new Object[]{object});
        return this.doInvoke(invoker);
    }

    protected Object invokeDelegateMethodWithArguments(Object[] args) {
        MethodInvoker invoker = this.createMethodInvoker(this.targetObject, this.targetMethod);
        invoker.setArguments(args);
        return this.doInvoke(invoker);
    }

    private MethodInvoker createMethodInvoker(Object targetObject, String targetMethod) {
        MethodInvoker invoker = new MethodInvoker();
        invoker.setTargetObject(targetObject);
        invoker.setTargetMethod(targetMethod);
        invoker.setArguments(this.arguments);
        return invoker;
    }

    private Object doInvoke(MethodInvoker invoker) {
        try {
            invoker.prepare();
        }
        catch (ClassNotFoundException e) {
            throw new DynamicMethodInvocationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new DynamicMethodInvocationException(e);
        }
        try {
            return invoker.invoke();
        }
        catch (InvocationTargetException e) {
            throw new DynamicMethodInvocationException(e);
        }
        catch (IllegalAccessException e) {
            throw new DynamicMethodInvocationException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.targetObject);
        Assert.hasLength((String)this.targetMethod);
        Assert.state((boolean)this.targetClassDeclaresTargetMethod(), (String)"target class must declare a method with name matching the target method");
    }

    private boolean targetClassDeclaresTargetMethod() {
        MethodInvoker invoker = this.createMethodInvoker(this.targetObject, this.targetMethod);
        Method[] methods = invoker.getTargetClass().getDeclaredMethods();
        String targetMethodName = invoker.getTargetMethod();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(targetMethodName)) continue;
            Class<?>[] params = methods[i].getParameterTypes();
            if (this.arguments == null) {
                return true;
            }
            if (this.arguments.length != params.length) continue;
            boolean argumentsMatchParameters = true;
            for (int j = 0; j < params.length; ++j) {
                if (params[j].isAssignableFrom(this.arguments[j].getClass())) continue;
                argumentsMatchParameters = false;
            }
            if (!argumentsMatchParameters) continue;
            return true;
        }
        return false;
    }

    public void setTargetObject(Object targetObject) {
        this.targetObject = targetObject;
    }

    public void setTargetMethod(String targetMethod) {
        this.targetMethod = targetMethod;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }
}

