/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.batch.item.file.mapping.BindingException;
import org.springframework.batch.item.file.mapping.FieldSet;
import org.springframework.batch.item.file.mapping.FieldSetMapper;
import org.springframework.batch.item.file.mapping.PropertyMatches;
import org.springframework.batch.support.DefaultPropertyEditorRegistrar;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.DataBinder;
import org.springframework.validation.ObjectError;

public class BeanWrapperFieldSetMapper
extends DefaultPropertyEditorRegistrar
implements FieldSetMapper,
BeanFactoryAware,
InitializingBean {
    private String name;
    private Class type;
    private BeanFactory beanFactory;
    private static Map propertiesMatched = new HashMap();
    private static int distanceLimit = 5;

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setPrototypeBeanName(String name) {
        this.name = name;
    }

    public void setTargetType(Class type) {
        this.type = type;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.name != null || this.type != null ? 1 : 0) != 0, (String)"Either name or type must be provided.");
        Assert.state((this.name == null || this.type == null ? 1 : 0) != 0, (String)"Both name and type cannot be specified together.");
    }

    public Object mapLine(FieldSet fs) {
        Object copy = this.getBean();
        DataBinder binder = this.createBinder(copy);
        binder.bind((PropertyValues)new MutablePropertyValues((Map)this.getBeanProperties(copy, fs.getProperties())));
        if (binder.getBindingResult().hasErrors()) {
            List errors = binder.getBindingResult().getAllErrors();
            ArrayList<String> messages = new ArrayList<String>(errors.size());
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                ObjectError error = (ObjectError)iterator.next();
                messages.add(error.getDefaultMessage());
            }
            throw new BindingException("" + messages);
        }
        return copy;
    }

    protected DataBinder createBinder(Object target) {
        DataBinder binder = new DataBinder(target);
        binder.setIgnoreUnknownFields(false);
        this.initBinder(binder);
        this.registerCustomEditors((PropertyEditorRegistry)binder);
        return binder;
    }

    protected void initBinder(DataBinder binder) {
    }

    private Object getBean() {
        if (this.name != null) {
            return this.beanFactory.getBean(this.name);
        }
        try {
            return this.type.newInstance();
        }
        catch (InstantiationException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        throw new IllegalStateException("Internal error: could not create bean instance for mapping.");
    }

    private Properties getBeanProperties(Object bean, Properties properties) {
        Class<?> cls = bean.getClass();
        HashMap<String, String> matches = (HashMap<String, String>)propertiesMatched.get(cls);
        if (matches == null) {
            matches = new HashMap<String, String>();
            propertiesMatched.put(cls, matches);
        }
        HashSet<Object> keys = new HashSet<Object>(properties.keySet());
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (matches.containsKey(key)) {
                this.switchPropertyNames(properties, key, (String)matches.get(key));
                continue;
            }
            String name = this.findPropertyName(bean, key);
            if (name == null) continue;
            matches.put(key, name);
            this.switchPropertyNames(properties, key, name);
        }
        return properties;
    }

    private String findPropertyName(Object bean, String key) {
        String suffix;
        String prefix;
        Class<?> cls = bean.getClass();
        int index = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex((String)key);
        if (index > 0) {
            String prefix2 = key.substring(0, index);
            String suffix2 = key.substring(index + 1, key.length());
            String nestedName = this.findPropertyName(bean, prefix2);
            if (nestedName == null) {
                return null;
            }
            Object nestedValue = new BeanWrapperImpl(bean).getPropertyValue(nestedName);
            String nestedPropertyName = this.findPropertyName(nestedValue, suffix2);
            return nestedPropertyName == null ? null : nestedName + "." + nestedPropertyName;
        }
        String name = null;
        int distance = 0;
        index = key.indexOf(91);
        if (index > 0) {
            prefix = key.substring(0, index);
            suffix = key.substring(index);
        } else {
            prefix = key;
            suffix = "";
        }
        while (name == null && distance <= distanceLimit) {
            String[] candidates = PropertyMatches.forProperty(prefix, cls, distance).getPossibleMatches();
            if (candidates.length == 1) {
                String candidate = candidates[0];
                name = candidate.equals(prefix) ? key : candidate + suffix;
            }
            ++distance;
        }
        return name;
    }

    private void switchPropertyNames(Properties properties, String oldName, String newName) {
        String value = properties.getProperty(oldName);
        properties.remove(oldName);
        properties.setProperty(newName, value);
    }
}

