/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.batch.item.file.mapping.DefaultFieldSet;
import org.springframework.batch.item.file.mapping.FieldSet;
import org.springframework.batch.item.file.transform.LineTokenizer;

public class PrefixMatchingCompositeLineTokenizer
implements LineTokenizer {
    private Map tokenizers = new HashMap();

    public void setTokenizers(Map tokenizers) {
        this.tokenizers = new LinkedHashMap(tokenizers);
    }

    public FieldSet tokenize(String line) {
        if (line == null) {
            return new DefaultFieldSet(new String[0]);
        }
        LineTokenizer tokenizer = null;
        LineTokenizer defaultTokenizer = null;
        Iterator iter = this.tokenizers.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if ("".equals(key)) {
                defaultTokenizer = (LineTokenizer)this.tokenizers.get(key);
                continue;
            }
            if (!line.startsWith(key)) continue;
            tokenizer = (LineTokenizer)this.tokenizers.get(key);
            break;
        }
        if (tokenizer == null) {
            tokenizer = defaultTokenizer;
        }
        if (tokenizer == null) {
            throw new IllegalStateException("Could not match record to tokenizer for line=[" + line + "]");
        }
        return tokenizer.tokenize(line);
    }
}

