/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.MarkFailedException;
import org.springframework.batch.item.NoWorkFoundException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.ResetFailedException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.item.util.ExecutionContextUserSupport;
import org.springframework.util.Assert;

public abstract class AbstractBufferedItemReaderItemStream
implements ItemReader,
ItemStream {
    private static final String READ_COUNT = "read.count";
    private int currentItemCount = 0;
    private int lastMarkedItemCount = 0;
    private boolean shouldReadBuffer = false;
    private List itemBuffer = new ArrayList();
    private ListIterator itemBufferIterator = null;
    private int lastMarkedBufferIndex = 0;
    private ExecutionContextUserSupport ecSupport = new ExecutionContextUserSupport();
    private boolean saveState = true;

    protected abstract Object doRead() throws Exception;

    protected abstract void doOpen() throws Exception;

    protected abstract void doClose() throws Exception;

    protected void jumpToItem(int itemIndex) throws Exception {
        for (int i = 0; i < itemIndex; ++i) {
            this.doRead();
        }
    }

    public Object read() throws Exception, UnexpectedInputException, NoWorkFoundException, ParseException {
        ++this.currentItemCount;
        if (this.shouldReadBuffer) {
            if (this.itemBufferIterator.hasNext()) {
                return this.itemBufferIterator.next();
            }
            this.shouldReadBuffer = false;
            this.itemBufferIterator = null;
        }
        Object item = this.doRead();
        this.itemBuffer.add(item);
        return item;
    }

    public void mark() throws MarkFailedException {
        if (!this.shouldReadBuffer) {
            this.itemBuffer.clear();
            this.itemBufferIterator = null;
            this.lastMarkedBufferIndex = 0;
        } else {
            this.lastMarkedBufferIndex = this.itemBufferIterator.nextIndex();
        }
        this.lastMarkedItemCount = this.currentItemCount;
    }

    public void reset() throws ResetFailedException {
        this.currentItemCount = this.lastMarkedItemCount;
        this.shouldReadBuffer = true;
        this.itemBufferIterator = this.itemBuffer.listIterator(this.lastMarkedBufferIndex);
    }

    protected int getCurrentItemCount() {
        return this.currentItemCount;
    }

    protected void setCurrentItemCount(int count) {
        this.currentItemCount = count;
    }

    public void close(ExecutionContext executionContext) throws ItemStreamException {
        this.currentItemCount = 0;
        this.lastMarkedItemCount = 0;
        this.lastMarkedBufferIndex = 0;
        this.itemBufferIterator = null;
        this.shouldReadBuffer = false;
        this.itemBuffer.clear();
        try {
            this.doClose();
        }
        catch (Exception e) {
            throw new ItemStreamException("Error while closing item reader", e);
        }
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        try {
            this.doOpen();
        }
        catch (Exception e) {
            throw new ItemStreamException("Failed to initialize the reader", e);
        }
        if (executionContext.containsKey(this.ecSupport.getKey(READ_COUNT))) {
            int itemCount = new Long(executionContext.getLong(this.ecSupport.getKey(READ_COUNT))).intValue();
            try {
                this.jumpToItem(itemCount);
            }
            catch (Exception e) {
                throw new ItemStreamException("Could not move to stored position on restart", e);
            }
            this.currentItemCount = itemCount;
        }
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.saveState) {
            Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
            executionContext.putLong(this.ecSupport.getKey(READ_COUNT), this.currentItemCount);
        }
    }

    public void setName(String name) {
        this.ecSupport.setName(name);
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }
}

