/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.util;

import java.io.File;
import java.io.IOException;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.util.Assert;

public class FileUtils {
    private FileUtils() {
    }

    public static void setUpOutputFile(File file, boolean restarted, boolean overwriteOutputFile) {
        Assert.notNull((Object)file);
        try {
            if (!restarted) {
                if (file.exists()) {
                    if (!overwriteOutputFile) {
                        throw new ItemStreamException("File already exists: [" + file.getAbsolutePath() + "]");
                    }
                    file.delete();
                }
                if (file.getParent() != null) {
                    new File(file.getParent()).mkdirs();
                }
                file.createNewFile();
                Assert.state((boolean)file.exists(), (String)"Output file must exist");
            }
        }
        catch (IOException ioe) {
            throw new ItemStreamException("Unable to create file: [" + file.getAbsolutePath() + "]", ioe);
        }
        if (!file.canWrite()) {
            throw new ItemStreamException("File is not writable: [" + file.getAbsolutePath() + "]");
        }
    }
}

