/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.interceptor;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryOperations;
import org.springframework.batch.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class RetryOperationsInterceptor
implements MethodInterceptor {
    private RetryOperations retryOperations = new RetryTemplate();

    public void setRetryTemplate(RetryOperations retryTemplate) {
        Assert.notNull((Object)retryTemplate, (String)"'retryOperations' cannot be null.");
        this.retryOperations = retryTemplate;
    }

    public Object invoke(final MethodInvocation invocation) throws Throwable {
        return this.retryOperations.execute(new RetryCallback(){

            public Object doWithRetry(RetryContext context) throws Throwable {
                if (invocation instanceof ProxyMethodInvocation) {
                    return ((ProxyMethodInvocation)invocation).invocableClone().proceed();
                }
                throw new IllegalStateException("MethodInvocation of the wrong type detected - this should not happen with Spring AOP, so please raise an issue if you see this exception");
            }
        });
    }
}

