/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.policy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.repeat.support.RepeatSynchronizationManager;
import org.springframework.batch.retry.ExhaustedRetryException;
import org.springframework.batch.retry.RecoveryCallback;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryException;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.TerminatedRetryException;
import org.springframework.batch.retry.callback.RecoveryRetryCallback;
import org.springframework.batch.retry.context.RetryContextSupport;
import org.springframework.batch.retry.policy.AbstractStatefulRetryPolicy;
import org.springframework.batch.retry.policy.SimpleRetryPolicy;
import org.springframework.util.Assert;

public class RecoveryCallbackRetryPolicy
extends AbstractStatefulRetryPolicy {
    protected Log logger = LogFactory.getLog(this.getClass());
    public static final String EXHAUSTED = RecoveryCallbackRetryPolicy.class.getName() + ".EXHAUSTED";
    private RetryPolicy delegate;

    public RecoveryCallbackRetryPolicy(RetryPolicy delegate) {
        this.delegate = delegate;
    }

    public RecoveryCallbackRetryPolicy() {
        this(new SimpleRetryPolicy());
    }

    public void setDelegate(RetryPolicy delegate) {
        this.delegate = delegate;
    }

    public boolean canRetry(RetryContext context) {
        return ((RetryPolicy)((Object)context)).canRetry(context);
    }

    public void close(RetryContext context) {
        ((RetryPolicy)((Object)context)).close(context);
    }

    public RetryContext open(RetryCallback callback, RetryContext parent) {
        Assert.state((boolean)(callback instanceof RecoveryRetryCallback), (String)"Callback must be RecoveryRetryCallback");
        RecoveryCallbackRetryContext context = new RecoveryCallbackRetryContext((RecoveryRetryCallback)callback, parent);
        context.open(callback, null);
        return context;
    }

    public void registerThrowable(RetryContext context, Throwable throwable) throws TerminatedRetryException {
        ((RetryPolicy)((Object)context)).registerThrowable(context, throwable);
    }

    public Object handleRetryExhausted(RetryContext context) throws ExhaustedRetryException {
        return ((RetryPolicy)((Object)context)).handleRetryExhausted(context);
    }

    private class RecoveryCallbackRetryContext
    extends RetryContextSupport
    implements RetryPolicy {
        private final Object key;
        private final int initialHashCode;
        private RetryContext delegateContext;
        private final RecoveryCallback recoverer;
        private final boolean forceRefresh;

        public RecoveryCallbackRetryContext(RecoveryRetryCallback callback, RetryContext parent) {
            super(parent);
            this.recoverer = callback.getRecoveryCallback();
            this.key = callback.getKey();
            this.forceRefresh = callback.isForceRefresh();
            this.initialHashCode = this.key.hashCode();
        }

        public boolean canRetry(RetryContext context) {
            return RecoveryCallbackRetryPolicy.this.delegate.canRetry(this.delegateContext);
        }

        public void close(RetryContext context) {
            RecoveryCallbackRetryPolicy.this.delegate.close(this.delegateContext);
        }

        public RetryContext open(RetryCallback callback, RetryContext parent) {
            if (this.forceRefresh) {
                this.delegateContext = RecoveryCallbackRetryPolicy.this.delegate.open(callback, null);
            } else if (RecoveryCallbackRetryPolicy.this.retryContextCache.containsKey(this.key)) {
                this.delegateContext = RecoveryCallbackRetryPolicy.this.retryContextCache.get(this.key);
                if (this.delegateContext == null) {
                    throw new RetryException("Inconsistent state for failed item: no history found. Consider whether equals() or hashCode() for the item might be inconsistent, or if you need to supply a better ItemKeyGenerator");
                }
            } else {
                this.delegateContext = RecoveryCallbackRetryPolicy.this.delegate.open(callback, null);
            }
            return null;
        }

        public void registerThrowable(RetryContext context, Throwable throwable) throws TerminatedRetryException {
            if (this.initialHashCode != this.key.hashCode()) {
                throw new RetryException("Inconsistent state for failed item key: hashCode has changed. Consider whether equals() or hashCode() for the item might be inconsistent, or if you need to supply a better ItemKeyGenerator");
            }
            RecoveryCallbackRetryPolicy.this.retryContextCache.put(this.key, this.delegateContext);
            RecoveryCallbackRetryPolicy.this.delegate.registerThrowable(this.delegateContext, throwable);
        }

        public boolean shouldRethrow(RetryContext context) {
            throw new UnsupportedOperationException("Not supported - this code should be unreachable.");
        }

        public Object handleRetryExhausted(RetryContext context) throws ExhaustedRetryException {
            RecoveryCallbackRetryPolicy.this.retryContextCache.remove(this.key);
            RepeatSynchronizationManager.setCompleteOnly();
            if (this.recoverer != null) {
                return this.recoverer.recover(context);
            }
            RecoveryCallbackRetryPolicy.this.logger.info((Object)"No recovery callback provided.  Returning null from recovery step.");
            return null;
        }

        public Throwable getLastThrowable() {
            return this.delegateContext.getLastThrowable();
        }

        public int getRetryCount() {
            return this.delegateContext.getRetryCount();
        }
    }
}

