/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionAwareProxyFactory {
    private Object target;

    public TransactionAwareProxyFactory(Object target) {
        this.target = this.begin(target);
    }

    protected final Object begin(Object target) {
        if (target instanceof List) {
            return new ArrayList((List)target);
        }
        if (target instanceof Set) {
            return new HashSet((Set)target);
        }
        if (target instanceof Map) {
            return new HashMap((Map)target);
        }
        throw new UnsupportedOperationException("Cannot copy target for this type: " + target.getClass());
    }

    protected void commit(Object copy, Object target) {
        if (target instanceof Collection) {
            ((Collection)target).clear();
            ((Collection)target).addAll((Collection)copy);
        } else {
            ((Map)target).clear();
            ((Map)target).putAll((Map)copy);
        }
    }

    public Object createInstance() {
        ProxyFactory factory = new ProxyFactory(this.target);
        factory.addAdvice((Advice)new MethodInterceptor(){

            public Object invoke(MethodInvocation invocation) throws Throwable {
                Object cache;
                if (!TransactionSynchronizationManager.isActualTransactionActive()) {
                    return invocation.proceed();
                }
                if (!TransactionSynchronizationManager.hasResource((Object)this)) {
                    cache = TransactionAwareProxyFactory.this.begin(TransactionAwareProxyFactory.this.target);
                    TransactionSynchronizationManager.bindResource((Object)this, (Object)cache);
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TargetSynchronization(this, cache));
                } else {
                    cache = TransactionSynchronizationManager.getResource((Object)this);
                }
                return invocation.getMethod().invoke(cache, invocation.getArguments());
            }
        });
        return factory.getProxy();
    }

    public static Map createTransactionalMap() {
        return (Map)new TransactionAwareProxyFactory(new HashMap()).createInstance();
    }

    public static Set createTransactionalSet() {
        return (Set)new TransactionAwareProxyFactory(new HashSet()).createInstance();
    }

    public static List createTransactionalList() {
        return (List)new TransactionAwareProxyFactory(new ArrayList()).createInstance();
    }

    private class TargetSynchronization
    extends TransactionSynchronizationAdapter {
        Object cache;
        Object key;

        public TargetSynchronization(Object key, Object cache) {
            this.cache = cache;
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterCompletion(int status) {
            super.afterCompletion(status);
            if (status == 0) {
                Object object = TransactionAwareProxyFactory.this.target;
                synchronized (object) {
                    TransactionAwareProxyFactory.this.commit(this.cache, TransactionAwareProxyFactory.this.target);
                }
            }
            TransactionSynchronizationManager.unbindResource((Object)this.key);
        }
    }
}

