/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.file.ResourceAwareItemWriterItemStream;
import org.springframework.batch.item.file.ResourceSuffixCreator;
import org.springframework.batch.item.file.SimpleResourceSuffixCreator;
import org.springframework.batch.item.util.ExecutionContextUserSupport;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiResourceItemWriter<T>
extends ExecutionContextUserSupport
implements ItemWriter<T>,
ItemStream {
    private static final String RESOURCE_INDEX_KEY = "resource.index";
    private static final String CURRENT_RESOURCE_ITEM_COUNT = "resource.item.count";
    private Resource resource;
    private ResourceAwareItemWriterItemStream<? super T> delegate;
    private int itemCountLimitPerResource = Integer.MAX_VALUE;
    private int currentResourceItemCount = 0;
    private int resourceIndex = 1;
    private ResourceSuffixCreator suffixCreator = new SimpleResourceSuffixCreator();
    private boolean saveState = true;

    public MultiResourceItemWriter() {
        this.setName(ClassUtils.getShortName(MultiResourceItemWriter.class));
    }

    @Override
    public void write(List<? extends T> items) throws Exception {
        if (this.currentResourceItemCount >= this.itemCountLimitPerResource) {
            this.delegate.close();
            ++this.resourceIndex;
            this.currentResourceItemCount = 0;
            this.setResourceToDelegate();
            this.delegate.open(new ExecutionContext());
        }
        this.delegate.write(items);
        this.currentResourceItemCount += items.size();
    }

    public void setResourceSuffixCreator(ResourceSuffixCreator suffixCreator) {
        this.suffixCreator = suffixCreator;
    }

    public void setItemCountLimitPerResource(int itemCountLimitPerResource) {
        this.itemCountLimitPerResource = itemCountLimitPerResource;
    }

    public void setDelegate(ResourceAwareItemWriterItemStream<? super T> delegate) {
        this.delegate = delegate;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    @Override
    public void close() throws ItemStreamException {
        this.resourceIndex = 1;
        this.currentResourceItemCount = 0;
        this.delegate.close();
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.resourceIndex = executionContext.getInt(this.getKey(RESOURCE_INDEX_KEY), 1);
        this.currentResourceItemCount = executionContext.getInt(this.getKey(CURRENT_RESOURCE_ITEM_COUNT), 0);
        try {
            this.setResourceToDelegate();
        }
        catch (IOException e) {
            throw new ItemStreamException("Couldn't open resource", e);
        }
        this.delegate.open(executionContext);
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.saveState) {
            this.delegate.update(executionContext);
            executionContext.putInt(this.getKey(CURRENT_RESOURCE_ITEM_COUNT), this.currentResourceItemCount);
            executionContext.putInt(this.getKey(RESOURCE_INDEX_KEY), this.resourceIndex);
        }
    }

    private void setResourceToDelegate() throws IOException {
        String path = this.resource.getFile().getAbsolutePath() + this.suffixCreator.getSuffix(this.resourceIndex);
        File file = new File(path);
        file.createNewFile();
        Assert.state((boolean)file.canWrite(), (String)("Output resource " + path + " must be writable"));
        this.delegate.setResource((Resource)new FileSystemResource(file));
    }
}

