/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.hibernate.SessionFactory;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.batch.item.database.HibernateItemReaderHelper;
import org.springframework.batch.item.database.orm.HibernateQueryProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePagingItemReader<T>
extends AbstractPagingItemReader<T>
implements ItemStream,
InitializingBean {
    private HibernateItemReaderHelper<T> helper = new HibernateItemReaderHelper();
    private Map<String, Object> parameterValues;
    private int fetchSize;

    public HibernatePagingItemReader() {
        this.setName(ClassUtils.getShortName(HibernatePagingItemReader.class));
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public void setQueryName(String queryName) {
        this.helper.setQueryName(queryName);
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setQueryProvider(HibernateQueryProvider queryProvider) {
        this.helper.setQueryProvider(queryProvider);
    }

    public void setQueryString(String queryString) {
        this.helper.setQueryString(queryString);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.helper.setSessionFactory(sessionFactory);
    }

    public void setUseStatelessSession(boolean useStatelessSession) {
        this.helper.setUseStatelessSession(useStatelessSession);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.state((this.fetchSize >= 0 ? 1 : 0) != 0, (String)"fetchSize must not be negative");
        this.helper.afterPropertiesSet();
    }

    @Override
    protected void doOpen() throws Exception {
        super.doOpen();
    }

    @Override
    protected void doReadPage() {
        if (this.results == null) {
            this.results = new CopyOnWriteArrayList();
        } else {
            this.results.clear();
        }
        this.results.addAll(this.helper.readPage(this.getPage(), this.getPageSize(), this.fetchSize, this.parameterValues));
    }

    @Override
    protected void doJumpToPage(int itemIndex) {
    }

    @Override
    protected void doClose() throws Exception {
        this.helper.close();
        super.doClose();
    }
}

