/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.adapter;

import java.lang.reflect.Method;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ReflectionUtils;

public class HippyMethodInvoker
extends MethodInvoker {
    protected Method findMatchingMethod() {
        String targetMethod = this.getTargetMethod();
        Object[] arguments = this.getArguments();
        int argCount = arguments.length;
        Method[] candidates = ReflectionUtils.getAllDeclaredMethods((Class)this.getTargetClass());
        int minTypeDiffWeight = Integer.MAX_VALUE;
        Method matchingMethod = null;
        Object[] transformedArguments = null;
        int transformedArgumentCount = 0;
        int i = 0;
        while (i < candidates.length) {
            Method candidate = candidates[i];
            if (candidate.getName().equals(targetMethod)) {
                int typeDiffWeight;
                Class[] paramTypes = candidate.getParameterTypes();
                Object[] candidateArguments = new Object[paramTypes.length];
                int assignedParameterCount = 0;
                int j = 0;
                while (j < arguments.length) {
                    int k = 0;
                    while (k < paramTypes.length) {
                        if (ClassUtils.isAssignableValue((Class)paramTypes[k], (Object)arguments[j]) && candidateArguments[k] == null) {
                            candidateArguments[k] = arguments[j];
                            ++assignedParameterCount;
                            break;
                        }
                        ++k;
                    }
                    ++j;
                }
                if (paramTypes.length <= argCount && (typeDiffWeight = HippyMethodInvoker.getTypeDifferenceWeight((Class[])paramTypes, (Object[])candidateArguments)) < minTypeDiffWeight) {
                    minTypeDiffWeight = typeDiffWeight;
                    matchingMethod = candidate;
                    transformedArguments = candidateArguments;
                    transformedArgumentCount = assignedParameterCount;
                }
            }
            ++i;
        }
        if (transformedArguments == null) {
            throw new IllegalArgumentException("No matching arguments found for method: " + targetMethod);
        }
        if (transformedArgumentCount < transformedArguments.length) {
            throw new IllegalArgumentException("Only " + transformedArgumentCount + " out of " + transformedArguments.length + " arguments could be assigned.");
        }
        this.setArguments(transformedArguments);
        return matchingMethod;
    }
}

