/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.springframework.batch.item.database.orm.HibernateQueryProvider;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateItemReaderHelper<T>
implements InitializingBean {
    private SessionFactory sessionFactory;
    private String queryString = "";
    private String queryName = "";
    private HibernateQueryProvider queryProvider;
    private boolean useStatelessSession = true;
    private StatelessSession statelessSession;
    private Session statefulSession;

    public void setQueryName(String queryName) {
        this.queryName = queryName;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setQueryProvider(HibernateQueryProvider queryProvider) {
        this.queryProvider = queryProvider;
    }

    public void setUseStatelessSession(boolean useStatelessSession) {
        Assert.state((this.statefulSession == null && this.statelessSession == null ? 1 : 0) != 0, (String)"The useStatelessSession flag can only be set before a session is initialized.");
        this.useStatelessSession = useStatelessSession;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.sessionFactory != null ? 1 : 0) != 0, (String)"A SessionFactory must be provided");
        if (this.queryProvider == null) {
            Assert.notNull((Object)this.sessionFactory, (String)"session factory must be set");
            Assert.state((boolean)(StringUtils.hasText((String)this.queryString) ^ StringUtils.hasText((String)this.queryName)), (String)"queryString or queryName must be set");
        } else {
            Assert.state((this.queryProvider != null ? 1 : 0) != 0, (String)"Hibernate query provider must be set");
        }
    }

    public ScrollableResults getForwardOnlyCursor(int fetchSize, Map<String, Object> parameterValues) {
        Query query = this.createQuery();
        if (parameterValues != null) {
            query.setProperties(parameterValues);
        }
        return query.setFetchSize(fetchSize).scroll(ScrollMode.FORWARD_ONLY);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Query createQuery() {
        if (this.useStatelessSession) {
            if (this.statelessSession == null) {
                this.statelessSession = this.sessionFactory.openStatelessSession();
            }
            if (this.queryProvider != null) {
                this.queryProvider.setStatelessSession(this.statelessSession);
                return this.queryProvider.createQuery();
            }
            if (!StringUtils.hasText((String)this.queryName)) return this.statelessSession.createQuery(this.queryString);
            return this.statelessSession.getNamedQuery(this.queryName);
        }
        if (this.statefulSession == null) {
            this.statefulSession = this.sessionFactory.openSession();
        }
        if (this.queryProvider != null) {
            this.queryProvider.setSession(this.statefulSession);
            return this.queryProvider.createQuery();
        }
        if (!StringUtils.hasText((String)this.queryName)) return this.statefulSession.createQuery(this.queryString);
        return this.statefulSession.getNamedQuery(this.queryName);
    }

    public void jumpToItem(ScrollableResults cursor, int itemIndex, int flushInterval) {
        int i = 0;
        while (i < itemIndex) {
            cursor.next();
            if (i % flushInterval == 0 && !this.useStatelessSession) {
                this.statefulSession.clear();
            }
            ++i;
        }
    }

    public void close() {
        if (this.statelessSession != null) {
            this.statelessSession.close();
            this.statelessSession = null;
        }
        if (this.statefulSession != null) {
            this.statefulSession.close();
            this.statefulSession = null;
        }
    }

    public Collection<? extends T> readPage(int page, int pageSize, int fetchSize, Map<String, Object> parameterValues) {
        this.clear();
        Query query = this.createQuery();
        if (parameterValues != null) {
            query.setProperties(parameterValues);
        }
        List result = query.setFetchSize(fetchSize).setFirstResult(page * pageSize).setMaxResults(pageSize).list();
        return result;
    }

    public void clear() {
        if (this.statefulSession != null) {
            this.statefulSession.clear();
        }
    }
}

