/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.ItemPreparedStatementSetter;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.JdbcParameterUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcBatchItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(JdbcBatchItemWriter.class);
    private SimpleJdbcOperations simpleJdbcTemplate;
    private ItemPreparedStatementSetter<T> itemPreparedStatementSetter;
    private ItemSqlParameterSourceProvider<T> itemSqlParameterSourceProvider;
    private String sql;
    private boolean assertUpdates = true;
    private int parameterCount;
    private boolean usingNamedParameters;

    public void setAssertUpdates(boolean assertUpdates) {
        this.assertUpdates = assertUpdates;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setItemPreparedStatementSetter(ItemPreparedStatementSetter<T> preparedStatementSetter) {
        this.itemPreparedStatementSetter = preparedStatementSetter;
    }

    public void setItemSqlParameterSourceProvider(ItemSqlParameterSourceProvider<T> itemSqlParameterSourceProvider) {
        this.itemSqlParameterSourceProvider = itemSqlParameterSourceProvider;
    }

    public void setDataSource(DataSource dataSource) {
        if (this.simpleJdbcTemplate == null) {
            this.simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
        }
    }

    public void setSimpleJdbcTemplate(SimpleJdbcOperations simpleJdbcTemplate) {
        this.simpleJdbcTemplate = simpleJdbcTemplate;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.simpleJdbcTemplate, (String)"A DataSource or a SimpleJdbcTemplate is required.");
        Assert.notNull((Object)this.sql, (String)"An SQL statement is required.");
        ArrayList<String> namedParameters = new ArrayList<String>();
        this.parameterCount = JdbcParameterUtils.countParameterPlaceholders(this.sql, namedParameters);
        if (namedParameters.size() > 0) {
            if (this.parameterCount != namedParameters.size()) {
                throw new InvalidDataAccessApiUsageException("You can't use both named parameters and classic \"?\" placeholders: " + this.sql);
            }
            this.usingNamedParameters = true;
        }
        if (this.usingNamedParameters) {
            Assert.notNull(this.itemSqlParameterSourceProvider, (String)"Using SQL statement with named parameters requires an ItemSqlParameterSourceProvider");
        } else {
            Assert.notNull(this.itemPreparedStatementSetter, (String)"Using SQL statement with '?' placeholders requires an ItemPreparedStatementSetter");
        }
    }

    @Override
    public void write(final List<? extends T> items) throws Exception {
        if (!items.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing batch with " + items.size() + " items."));
            }
            int[] updateCounts = null;
            if (this.usingNamedParameters) {
                SqlParameterSource[] batchArgs = new SqlParameterSource[items.size()];
                int i = 0;
                for (T item : items) {
                    batchArgs[i++] = this.itemSqlParameterSourceProvider.createSqlParameterSource(item);
                }
                updateCounts = this.simpleJdbcTemplate.batchUpdate(this.sql, batchArgs);
            } else {
                updateCounts = (int[])this.simpleJdbcTemplate.getJdbcOperations().execute(this.sql, new PreparedStatementCallback(){

                    public Object doInPreparedStatement(PreparedStatement ps) throws SQLException, DataAccessException {
                        for (Object item : items) {
                            JdbcBatchItemWriter.this.itemPreparedStatementSetter.setValues(item, ps);
                            ps.addBatch();
                        }
                        return ps.executeBatch();
                    }
                });
            }
            if (this.assertUpdates) {
                int i = 0;
                while (i < updateCounts.length) {
                    int value = updateCounts[i];
                    if (value == 0) {
                        throw new EmptyResultDataAccessException("Item " + i + " of " + updateCounts.length + " did not update any rows: [" + items.get(i) + "]", 1);
                    }
                    ++i;
                }
            }
        }
    }
}

