/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DatabaseType {
    DERBY("Apache Derby"),
    DB2("DB2"),
    DB2ZOS("DB2ZOS"),
    HSQL("HSQL Database Engine"),
    SQLSERVER("Microsoft SQL Server"),
    MYSQL("MySQL"),
    ORACLE("Oracle"),
    POSTGRES("PostgreSQL"),
    SYBASE("Sybase"),
    H2("H2");

    private static final Map<String, DatabaseType> nameMap;
    private final String productName;

    static {
        nameMap = new HashMap<String, DatabaseType>();
        DatabaseType[] databaseTypeArray = DatabaseType.values();
        int n = databaseTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DatabaseType type = databaseTypeArray[n2];
            nameMap.put(type.getProductName(), type);
            ++n2;
        }
    }

    private DatabaseType(String productName) {
        this.productName = productName;
    }

    public String getProductName() {
        return this.productName;
    }

    public static DatabaseType fromProductName(String productName) {
        if (!nameMap.containsKey(productName)) {
            throw new IllegalArgumentException("DatabaseType not found for product name: [" + productName + "]");
        }
        return nameMap.get(productName);
    }

    public static DatabaseType fromMetaData(DataSource dataSource) throws MetaDataAccessException {
        String databaseProductVersion;
        String databaseProductName = JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (String)"getDatabaseProductName").toString();
        databaseProductName = "DB2".equals(databaseProductName) ? (!(databaseProductVersion = JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, (String)"getDatabaseProductVersion").toString()).startsWith("SQL") ? "DB2ZOS" : JdbcUtils.commonDatabaseName((String)databaseProductName)) : JdbcUtils.commonDatabaseName((String)databaseProductName);
        return DatabaseType.fromProductName(databaseProductName);
    }
}

